/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.MatrixCursor;
import com.tencent.mm.sdk.platformtools.Log;
import com.tencent.mm.sdk.storage.CursorFieldHelper;
import com.tencent.mm.sdk.storage.MDBItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MAutoDBItem
implements MDBItem {
    public static final String SYSTEM_ROWID_FIELD = "rowid";
    public long systemRowid = -1L;

    protected abstract Field[] fields();

    public static Field[] getValidFields(Class<?> fieldArray) {
        LinkedList<Field> linkedList = new LinkedList<Field>();
        for (Field field : fieldArray.getDeclaredFields()) {
            int n = field.getModifiers();
            String string = field.getName();
            if (string == null || !string.startsWith("field_") || !Modifier.isPublic(n) || Modifier.isFinal(n)) continue;
            if (string.endsWith("field_rowid")) {
                Assert.assertTrue((String)"field_rowid reserved by MAutoDBItem, change now!", (boolean)false);
            }
            linkedList.add(field);
        }
        return linkedList.toArray(new Field[0]);
    }

    @Override
    public void convertFrom(Cursor cursor) {
        for (Field field : this.fields()) {
            Object object = field.getName().substring(6);
            int n = 0;
            try {
                n = cursor.getColumnIndexOrThrow((String)object);
            }
            catch (Exception exception) {
                continue;
            }
            if (n == -1) continue;
            try {
                object = CursorFieldHelper.get(field.getType(), false);
                if (object == null) continue;
                ((Method)object).invoke(null, field, this, cursor, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n = -1;
        try {
            n = cursor.getColumnIndexOrThrow(SYSTEM_ROWID_FIELD);
        }
        catch (Exception exception) {}
        if (n > 0) {
            this.systemRowid = cursor.getLong(n);
        }
    }

    @Override
    public ContentValues convertTo() {
        ContentValues contentValues = new ContentValues();
        for (Field field : this.fields()) {
            Method method;
            try {
                method = CursorFieldHelper.get(field.getType(), true);
                if (method == null) continue;
                method.invoke(null, field, this, contentValues);
            }
            catch (Exception exception) {
                method = null;
                exception.printStackTrace();
            }
        }
        if (this.systemRowid > 0L) {
            contentValues.put(SYSTEM_ROWID_FIELD, Long.valueOf(this.systemRowid));
        }
        return contentValues;
    }

    public static Cursor getCursorForProjection(ContentValues contentValues, String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = contentValues.get(stringArray[i]);
        }
        MatrixCursor matrixCursor = new MatrixCursor(stringArray);
        matrixCursor.addRow(objectArray);
        return matrixCursor;
    }

    public static Map<String, String> identify(Field[] fieldArray, StringBuilder stringBuilder, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = CursorFieldHelper.type(fieldArray[i].getType());
            if (string2 == null) {
                Log.e("MicroMsg.SDK.MAutoDBItem", "failed identify on column: " + fieldArray[i].getName() + ", skipped");
                continue;
            }
            String string3 = fieldArray[i].getName().substring(6);
            if (stringBuilder != null) {
                stringBuilder.append(string3 + " " + string2 + (string3.equals(string) ? " PRIMARY KEY " : ""));
                stringBuilder.append(i == fieldArray.length - 1 ? "" : ", ");
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    public static String[] getFullColumns(Field[] fieldArray) {
        String[] stringArray = new String[fieldArray.length + 1];
        for (int i = 0; i < fieldArray.length; ++i) {
            stringArray[i] = fieldArray[i].getName().substring(6);
        }
        stringArray[fieldArray.length] = SYSTEM_ROWID_FIELD;
        return stringArray;
    }

    public static boolean checkIOEqual(ContentValues contentValues, Cursor cursor) {
        if (contentValues == null) {
            return cursor == null;
        }
        if (cursor == null || cursor.getCount() != 1) {
            return false;
        }
        cursor.moveToFirst();
        int n = cursor.getColumnCount();
        int n2 = contentValues.size();
        if (contentValues.containsKey(SYSTEM_ROWID_FIELD)) {
            --n2;
        }
        if (cursor.getColumnIndex(SYSTEM_ROWID_FIELD) != -1) {
            --n;
        }
        if (n2 != n) {
            return false;
        }
        try {
            Iterator iterator = contentValues.valueSet().iterator();
            while (iterator.hasNext()) {
                Object object = (String)((Map.Entry)iterator.next()).getKey();
                if (((String)object).equals(SYSTEM_ROWID_FIELD)) continue;
                int n3 = cursor.getColumnIndex((String)object);
                if (n3 == -1) {
                    return false;
                }
                if (contentValues.get((String)object) instanceof byte[]) {
                    byte[] byArray;
                    if (((Object)(object = (Object)((byte[])contentValues.get((String)object)))).length != (byArray = cursor.getBlob(n3)).length) {
                        return false;
                    }
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (object[i] == byArray[i]) continue;
                        return false;
                    }
                    continue;
                }
                if (cursor.getString(n3) == null && contentValues.get((String)object) != null) {
                    return false;
                }
                if (contentValues.get((String)object) == null) {
                    return false;
                }
                if (contentValues.get((String)object).toString().equals(cursor.getString(n3))) continue;
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

