/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.os.Process;
import com.tencent.mm.sdk.platformtools.Log;
import java.io.File;
import java.util.Scanner;

public final class TrafficStats {
    private static long bl;
    private static long bm;
    private static long bn;
    private static long bo;
    private static long bp;
    private static long bq;
    private static long br;
    private static long bs;
    public static final String DEV_FILE = "/proc/self/net/dev";
    public static final String GPRSLINE = "rmnet0";
    public static final String WIFILINE = "tiwlan0";

    private TrafficStats() {
    }

    public static long getWifiTx(long l) {
        if (br > l) {
            return br;
        }
        return l;
    }

    public static long getWifiRx(long l) {
        if (bs > l) {
            return bs;
        }
        return l;
    }

    public static long getMobileTx(long l) {
        if (bp > l) {
            return bp;
        }
        return l;
    }

    public static long getMobileRx(long l) {
        if (bq > l) {
            return bq;
        }
        return l;
    }

    public static long updateWifiTx(long l) {
        TrafficStats.update();
        return TrafficStats.getWifiTx(l);
    }

    public static long updateWifiRx(long l) {
        TrafficStats.update();
        return TrafficStats.getWifiRx(l);
    }

    public static long updateMobileTx(long l) {
        TrafficStats.update();
        return TrafficStats.getMobileTx(l);
    }

    public static long updateMobileRx(long l) {
        TrafficStats.update();
        return TrafficStats.getMobileRx(l);
    }

    public static void reset() {
        bl = -1L;
        bm = -1L;
        bn = -1L;
        bo = -1L;
        TrafficStats.update();
    }

    public static void update() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        try {
            Scanner scanner = new Scanner(new File("/proc/" + Process.myPid() + "/net/dev"));
            scanner.nextLine();
            scanner.nextLine();
            while (scanner.hasNext()) {
                int n;
                String[] stringArray = scanner.nextLine().split("[ :\t]+");
                int n2 = n = stringArray[0].length() == 0 ? 1 : 0;
                if (!stringArray[0].equals("lo") && stringArray[n + 0].startsWith("rmnet")) {
                    l += Long.parseLong(stringArray[n + 9]);
                    l2 += Long.parseLong(stringArray[n + 1]);
                }
                if (stringArray[n + 0].equals("lo") || stringArray[n + 0].startsWith("rmnet")) continue;
                l3 += Long.parseLong(stringArray[n + 9]);
                l4 += Long.parseLong(stringArray[n + 1]);
            }
            scanner.close();
            if (bl < 0L) {
                bl = l;
                Log.v("MicroMsg.SDK.TrafficStats", "fix loss newMobileTx %d", l);
            }
            if (bm < 0L) {
                bm = l2;
                Log.v("MicroMsg.SDK.TrafficStats", "fix loss newMobileRx %d", l2);
            }
            if (bn < 0L) {
                bn = l3;
                Log.v("MicroMsg.SDK.TrafficStats", "fix loss newWifiTx %d", l3);
            }
            if (bo < 0L) {
                bo = l4;
                Log.v("MicroMsg.SDK.TrafficStats", "fix loss newWifiRx %d", l4);
            }
            if (l4 - bo < 0L) {
                Log.v("MicroMsg.SDK.TrafficStats", "minu %d", l4 - bo);
            }
            if (l3 - bn < 0L) {
                Log.v("MicroMsg.SDK.TrafficStats", "minu %d", l3 - bn);
            }
            bp = l >= bl ? l - bl : l;
            bq = l2 >= bm ? l2 - bm : l2;
            br = l3 >= bn ? l3 - bn : l3;
            bs = l4 >= bo ? l4 - bo : l4;
            bl = l;
            bm = l2;
            bn = l3;
            bo = l4;
        }
        catch (Exception exception) {
            Object var8_5 = null;
            exception.printStackTrace();
        }
        Log.d("MicroMsg.SDK.TrafficStats", "current system traffic: wifi rx/tx=%d/%d, mobile rx/tx=%d/%d", bs, br, bq, bp);
    }
}

