/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.content.Context;
import android.os.Build;
import com.tencent.mm.sdk.platformtools.PhoneUtil16Impl;
import com.tencent.mm.sdk.platformtools.PhoneUtil20Impl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhoneUtil {
    public static final String CELL_GSM = "gsm";
    public static final String CELL_CDMA = "cdma";
    private static final int aJ = 17;

    private PhoneUtil() {
    }

    public static String getMacXml(List<MacInfo> list) {
        String string = "";
        if (list == null || list.size() <= 0) {
            return "";
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || list.get((int)i).mac.length() != aJ) continue;
            string = string + "<mac ";
            string = string + "macDbm=\"" + list.get((int)i).dbm + "\"";
            string = string + ">";
            string = string + list.get((int)i).mac;
            string = string + "</mac>";
        }
        return string;
    }

    public static String getCellXml(List<CellInfo> list) {
        String string = "";
        if (list == null || list.size() <= 0) {
            return "";
        }
        for (int i = 0; i < list.size(); ++i) {
            string = string + "<cell ";
            string = string + "mcc=\"" + list.get((int)i).mcc + "\" ";
            string = string + "mnc=\"" + list.get((int)i).mnc + "\" ";
            string = string + "lac=\"" + list.get((int)i).lac + "\" ";
            string = string + "type=\"" + list.get((int)i).type + "\" ";
            string = string + "stationId=\"" + list.get((int)i).stationId + "\" ";
            string = string + "networkId=\"" + list.get((int)i).networkId + "\" ";
            string = string + "systemId=\"" + list.get((int)i).systemId + "\" ";
            string = string + "dbm=\"" + list.get((int)i).dbm + "\" ";
            string = string + " >";
            string = string + list.get((int)i).cellid;
            string = string + "</cell>";
        }
        return string;
    }

    public static void getSignalStrength(Context context) {
        if (Integer.valueOf(Build.VERSION.SDK) >= 5) {
            new PhoneUtil20Impl().getSignalStrength(context);
            return;
        }
        new PhoneUtil16Impl().getSignalStrength(context);
    }

    public static List<CellInfo> getCellInfoList(Context context) {
        if (Integer.valueOf(Build.VERSION.SDK) >= 5) {
            return new PhoneUtil20Impl().getCellInfoList(context);
        }
        return new PhoneUtil16Impl().getCellInfoList(context);
    }

    public static class MacInfo {
        public String mac;
        public String dbm;

        public MacInfo(String string, String string2) {
            this.mac = string;
            this.dbm = string2;
        }
    }

    public static class CellInfo {
        public static final int MAX_CID = 65535;
        public static final int MAX_LAC = 65535;
        public String mcc;
        public String mnc;
        public String lac;
        public String cellid;
        public String type;
        public String stationId;
        public String networkId;
        public String systemId;
        public String dbm;

        public CellInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
            this.mcc = string;
            this.mnc = string2;
            this.lac = string3;
            this.type = string6;
            this.cellid = string4;
            this.stationId = string7;
            this.networkId = string8;
            this.systemId = string9;
            this.dbm = string5;
        }
    }
}

