/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.widget.ListView;
import com.tencent.mm.sdk.platformtools.AnimationHelperImpl21below;
import com.tencent.mm.sdk.platformtools.AnimationHelperImpl22;
import com.tencent.mm.sdk.platformtools.Log;
import com.tencent.mm.sdk.platformtools.SmoothScrollToPosition21below;
import com.tencent.mm.sdk.platformtools.SmoothScrollToPosition22;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class BackwardSupportUtil {

    public static class ExifHelper {
        public static int getExifOrientation(String string) {
            int n;
            int n2 = 0;
            ExifInterface exifInterface = null;
            try {
                exifInterface = new ExifInterface(string);
            }
            catch (IOException iOException) {
                Log.e("MicroMsg.SDK.BackwardSupportUtil", "cannot read exif" + iOException);
            }
            if (exifInterface != null && (n = exifInterface.getAttributeInt("Orientation", -1)) != -1) {
                switch (n) {
                    case 6: {
                        n2 = 90;
                        break;
                    }
                    case 3: {
                        n2 = 180;
                        break;
                    }
                    case 8: {
                        n2 = 270;
                    }
                }
            }
            return n2;
        }
    }

    public static class AnimationHelper {
        public static void cancelAnimation(View view, Animation animation) {
            if (Build.VERSION.SDK_INT >= 8) {
                new AnimationHelperImpl22().cancelAnimation(view, animation);
                return;
            }
            new AnimationHelperImpl21below().cancelAnimation(view, animation);
        }

        public static void overridePendingTransition(Activity activity, int n, int n2) {
            activity.overridePendingTransition(n, n2);
        }

        public static interface IHelper {
            public void cancelAnimation(View var1, Animation var2);
        }
    }

    public static class SmoothScrollFactory {
        public static void scrollToTop(ListView listView) {
            if (Build.VERSION.SDK_INT >= 8) {
                new SmoothScrollToPosition22().doScroll(listView);
                return;
            }
            new SmoothScrollToPosition21below().doScroll(listView);
        }

        public static void scrollTo(ListView listView, int n) {
            if (Build.VERSION.SDK_INT >= 8) {
                new SmoothScrollToPosition22().doScroll(listView, n);
                return;
            }
            new SmoothScrollToPosition21below().doScroll(listView, n);
        }

        public static interface IScroll {
            public void doScroll(ListView var1);

            public void doScroll(ListView var1, int var2);
        }
    }

    public static class BitmapFactory {
        public static Bitmap decodeFile(String string, float f) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inDensity = (int)(f *= 160.0f);
            if ((string = android.graphics.BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options)) != null) {
                string.setDensity((int)f);
            }
            return string;
        }

        public static int fromDPToPix(Context context, float f) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            return Math.round(f * (float)displayMetrics.densityDpi / 160.0f);
        }

        public static Bitmap decodeStream(InputStream inputStream) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inDensity = 160;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return android.graphics.BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }

        public static Bitmap decodeStream(InputStream inputStream, float f) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inDensity = (int)(f * 160.0f);
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return android.graphics.BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }

        public static String getDisplayDensityType(Context context) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            context = context.getResources().getConfiguration();
            String string = "";
            string = displayMetrics.density < 1.0f ? string + "LDPI" : (displayMetrics.density >= 1.5f ? string + "HDPI" : string + "MDPI");
            return string + (context.orientation == 2 ? "_L" : "_P");
        }

        public static Bitmap getBitmapFromURL(String object) {
            try {
                Log.d("MicroMsg.SDK.BackwardSupportUtil", "get bitmap from url:" + (String)object);
                URL uRL = new URL((String)object);
                object = null;
                object = (HttpURLConnection)uRL.openConnection();
                ((URLConnection)object).setDoInput(true);
                ((URLConnection)object).connect();
                object = ((URLConnection)object).getInputStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)object);
                ((InputStream)object).close();
                object = bitmap;
                return object;
            }
            catch (IOException iOException) {
                Log.e("MicroMsg.SDK.BackwardSupportUtil", "get bitmap from url failed");
                iOException.printStackTrace();
            }
            return null;
        }
    }
}

