/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.openapi;

import android.graphics.Bitmap;
import android.os.Bundle;
import com.tencent.mm.sdk.openapi.WXMediaMessage;
import com.tencent.mm.sdk.platformtools.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class WXImageObject
implements WXMediaMessage.IMediaObject {
    public byte[] imageData;
    public String imagePath;
    public String imageUrl;

    public WXImageObject() {
    }

    public WXImageObject(byte[] byArray) {
        this.imageData = byArray;
    }

    public WXImageObject(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setImagePath(String string) {
        this.imagePath = string;
    }

    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wximageobject_imageData", this.imageData);
        bundle.putString("_wximageobject_imagePath", this.imagePath);
        bundle.putString("_wximageobject_imageUrl", this.imageUrl);
    }

    public void unserialize(Bundle bundle) {
        this.imageData = bundle.getByteArray("_wximageobject_imageData");
        this.imagePath = bundle.getString("_wximageobject_imagePath");
        this.imageUrl = bundle.getString("_wximageobject_imageUrl");
    }

    public int type() {
        return 2;
    }

    public boolean checkArgs() {
        Object object;
        if (!(this.imageData != null && this.imageData.length != 0 || this.imagePath != null && this.imagePath.length() != 0 || this.imageUrl != null && this.imageUrl.length() != 0)) {
            Log.e("MicroMsg.SDK.WXImageObject", "checkArgs fail, all arguments are null");
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0xA00000) {
            Log.e("MicroMsg.SDK.WXImageObject", "checkArgs fail, content is too large");
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 10240) {
            Log.e("MicroMsg.SDK.WXImageObject", "checkArgs fail, path is invalid");
            return false;
        }
        if (this.imagePath != null && ((object = this.imagePath) == null || ((String)object).length() == 0 ? 0 : (!((File)(object = new File((String)object))).exists() ? 0 : (int)((File)object).length())) > 0xA00000) {
            Log.e("MicroMsg.SDK.WXImageObject", "checkArgs fail, image content is too large");
            return false;
        }
        if (this.imageUrl != null && this.imageUrl.length() > 10240) {
            Log.e("MicroMsg.SDK.WXImageObject", "checkArgs fail, url is invalid");
            return false;
        }
        return true;
    }
}

