/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.view.MotionEvent;
import android.view.View;
import com.tencent.mm.algorithm.MD5;
import com.tencent.mm.sdk.platformtools.Log;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    public static final int MAX_DECODE_PICTURE_SIZE = 2764800;
    public static final String PHOTO_DEFAULT_EXT = ".jpg";
    public static final long MILLSECONDS_OF_SECOND = 1000L;
    public static final long MILLSECONDS_OF_MINUTE = 60000L;
    public static final long MILLSECONDS_OF_HOUR = 3600000L;
    public static final long MILLSECONDS_OF_DAY = 86400000L;
    public static final long SECOND_OF_MINUTE = 60L;
    public static final long MINUTE_OF_HOUR = 60L;
    public static final long MAX_32BIT_VALUE = 0xFFFFFFFFL;
    public static final int MIN_ACCOUNT_LENGTH = 6;
    public static final int MAX_ACCOUNT_LENGTH = 20;
    public static final int MIN_PASSWORD_LENGTH = 4;
    public static final int MAX_PASSWORD_LENGTH = 9;
    public static final int BIT_OF_KB = 10;
    public static final int BIT_OF_MB = 20;
    public static final int BYTE_OF_KB = 1024;
    public static final int BYTE_OF_MB = 0x100000;
    public static final int MASK_4BIT = 15;
    public static final int MASK_8BIT = 255;
    public static final int MASK_16BIT = 65535;
    public static final int MASK_32BIT = -1;
    public static final int BEGIN_TIME = 22;
    public static final int END_TIME = 8;
    public static final int DAY = 0;
    public static final String TAIWAN = "zh_TW";
    public static final String HONGKONG = "zh_HK";
    public static final String CHINA = "zh_CN";
    public static final String ENGLISH = "en";
    public static final String LANGUAGE_DEFAULT = "language_default";
    private static final long[] bt = new long[]{300L, 200L, 300L, 200L};
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final char[] bu = new char[]{'\t', '\n', '\r'};
    private static final char[] bv = new char[]{'<', '>', '\"', '\'', '&'};
    private static final String[] bw = new String[]{"&lt;", "&gt;", "&quot;", "&apos;", "&amp;"};

    private Util() {
    }

    public static String escapeSqlValue(String string) {
        if (string != null) {
            string = string.replace("\\[", "[[]").replace("%", "").replace("\\^", "").replace("'", "").replace("\\{", "").replace("\\}", "").replace("\"", "");
        }
        return string;
    }

    public static String listToString(List<String> list, String string) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < list.size(); ++i) {
            if (i == list.size() - 1) {
                stringBuilder.append(list.get(i).trim());
                continue;
            }
            stringBuilder.append(list.get(i).trim() + string);
        }
        return stringBuilder.toString();
    }

    public static List<String> stringsToList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static int getIntRandom(int n, int n2) {
        Assert.assertTrue((n > n2 ? 1 : 0) != 0);
        return new Random(System.currentTimeMillis()).nextInt(n - n2 + 1) + n2;
    }

    public static boolean isDayTimeNow() {
        int n = new GregorianCalendar().get(11);
        return (long)n >= 6L && (long)n < 18L;
    }

    public static boolean isNightTime(int n, int n2, int n3) {
        if (n2 > n3) {
            return n >= n2 || n <= n3;
        }
        if (n2 < n3) {
            return n <= n3 && n >= n2;
        }
        return true;
    }

    public static String getTimeZoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        double d = (double)((long)(timeZone.getRawOffset() * 100) / 3600000L) / 100.0 + (double)(timeZone.useDaylightTime() ? 1 : 0);
        return String.format("%.2f", d);
    }

    public static String getTimeZone() {
        String string = Util.getTimeZoneDef();
        int n = string.indexOf(43);
        if (n == -1) {
            n = string.indexOf(45);
        }
        if (n == -1) {
            return "";
        }
        if ((string = string.substring(n, n + 3)).charAt(1) == '0') {
            string = string.substring(0, 1) + string.substring(2, 3);
        }
        return string;
    }

    public static String getTimeZoneDef() {
        int n = (int)((long)TimeZone.getDefault().getRawOffset() / 60000L);
        char c = '+';
        if (n < 0) {
            c = '-';
            n = -n;
        }
        return String.format("GMT%s%02d:%02d", Character.valueOf(c), (long)n / 60L, (long)n % 60L);
    }

    public static String formatUnixTime(long l) {
        return new SimpleDateFormat("[yy-MM-dd HH:mm:ss]").format(new Date(l * 1000L));
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.GENERAL_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isNum(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isValidQQNum(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        string = string.trim();
        try {
            long l = Long.valueOf(string);
            return l > 0L && l <= 0xFFFFFFFFL;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return false;
        }
    }

    public static boolean isValidEmail(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.trim().matches("^[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]$");
    }

    public static byte[] bmpToByteArray(Bitmap object, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        if (bl) {
            object.recycle();
        }
        object = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public static boolean isValidAccount(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() < 6 || string.length() > 20) {
            return false;
        }
        if (!Util.isAlpha(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Util.isAlpha(c) || Util.isNum(c) || c == '-' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPassword(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 4) {
            return false;
        }
        if (string.length() >= 9) {
            return true;
        }
        try {
            Integer.parseInt(string);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    public static BitmapFactory.Options getImageOptions(String string) {
        Assert.assertTrue((string != null && !string.equals("") ? 1 : 0) != 0);
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        try {
            string = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            if (string != null) {
                string.recycle();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e("MicroMsg.Util", "decode bitmap failed: " + outOfMemoryError.getMessage());
        }
        return options;
    }

    public static void saveBitmapToImage(Bitmap bitmap, int n, Bitmap.CompressFormat compressFormat, String object, String object2, boolean bl) {
        Assert.assertTrue((object != null && object2 != null ? 1 : 0) != 0);
        Log.d("MicroMsg.Util", "saving to " + (String)object + (String)object2);
        object = new File((String)object + (String)object2);
        ((File)object).createNewFile();
        object2 = null;
        try {
            object2 = new FileOutputStream((File)object);
            bitmap.compress(compressFormat, n, (OutputStream)object2);
            ((OutputStream)object2).flush();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    public static void saveBitmapToImage(Bitmap bitmap, int n, Bitmap.CompressFormat compressFormat, String object, boolean bl) {
        Assert.assertTrue((!Util.isNullOrNil((String)object) ? 1 : 0) != 0);
        Log.d("MicroMsg.Util", "saving to " + (String)object);
        object = new File((String)object);
        ((File)object).createNewFile();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((File)object);
            bitmap.compress(compressFormat, n, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bitmap = null;
            fileNotFoundException.printStackTrace();
            return;
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, boolean bl, float f) {
        Assert.assertNotNull((Object)bitmap);
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setFilterBitmap(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-4144960);
        canvas.drawRoundRect(rectF, f, f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        if (bl) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static String getSizeKB(long l) {
        if (l >> 20 > 0L) {
            return Util.getSizeMB(l);
        }
        if (l >> 9 > 0L) {
            float f = (float)Math.round((float)l * 10.0f / 1024.0f) / 10.0f;
            return f + "KB";
        }
        return l + "B";
    }

    public static String getSizeMB(long l) {
        float f = (float)Math.round((float)l * 10.0f / 1048576.0f) / 10.0f;
        return f + "MB";
    }

    public static String dumpArray(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(object);
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static String dumpHex(byte[] byArray) {
        if (byArray == null) {
            return "(null)";
        }
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int n = byArray.length;
        char[] cArray2 = new char[n * 3 + n / 16];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            cArray2[n2++] = 32;
            cArray2[n2++] = cArray[by >>> 4 & 0xF];
            cArray2[n2++] = cArray[by & 0xF];
            if (i % 16 != 0 || i <= 0) continue;
            cArray2[n2++] = 10;
        }
        return new String(cArray2);
    }

    public static Intent getInstallPackIntent(String string, Context context) {
        Assert.assertTrue((string != null && !string.equals("") ? 1 : 0) != 0);
        context = new Intent("android.intent.action.VIEW");
        context.addFlags(0x10000000);
        context.setDataAndType(Uri.fromFile((File)new File(string)), "application/vnd.android.package-archive");
        return context;
    }

    public static void installPack(String string, Context context) {
        context.startActivity(Util.getInstallPackIntent(string, context));
    }

    public static void shake(Context context, boolean bl) {
        if ((context = (Vibrator)context.getSystemService("vibrator")) == null) {
            return;
        }
        if (bl) {
            context.vibrate(bt, -1);
            return;
        }
        context.cancel();
    }

    public static MediaPlayer playSound(Context context, int n, MediaPlayer.OnCompletionListener onCompletionListener) {
        try {
            String string = context.getString(n);
            context = context.getAssets().openFd(string);
            string = new MediaPlayer();
            string.setDataSource(context.getFileDescriptor(), context.getStartOffset(), context.getLength());
            context.close();
            string.prepare();
            string.setLooping(false);
            string.start();
            string.setOnCompletionListener(onCompletionListener);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void playSound(Context context, int n) {
        Util.playSound(context, n, new MediaPlayer.OnCompletionListener(){

            public final void onCompletion(MediaPlayer mediaPlayer) {
                mediaPlayer.release();
            }
        });
    }

    public static long nowSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String formatSecToMin(int n) {
        return String.format("%d:%02d", (long)n / 60L, (long)n % 60L);
    }

    public static long nowMilliSecond() {
        return System.currentTimeMillis();
    }

    public static long secondsToNow(long l) {
        return System.currentTimeMillis() / 1000L - l;
    }

    public static long milliSecondsToNow(long l) {
        return System.currentTimeMillis() - l;
    }

    public static long ticksToNow(long l) {
        return SystemClock.elapsedRealtime() - l;
    }

    public static long currentTicks() {
        return SystemClock.elapsedRealtime();
    }

    public static long currentDayInMills() {
        return Util.nowMilliSecond() / 86400000L * 86400000L;
    }

    public static long currentWeekInMills() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
        gregorianCalendar2.setTimeZone(GMT);
        int n = gregorianCalendar.get(7) - gregorianCalendar.getFirstDayOfWeek();
        gregorianCalendar2.add(6, -n);
        return gregorianCalendar2.getTimeInMillis();
    }

    public static long currentMonthInMills() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), 1);
        gregorianCalendar.setTimeZone(GMT);
        return gregorianCalendar.getTimeInMillis();
    }

    public static long currentYearInMills() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar = new GregorianCalendar(gregorianCalendar.get(1), 1, 1);
        gregorianCalendar.setTimeZone(GMT);
        return gregorianCalendar.getTimeInMillis();
    }

    public static int getSystemVersion(Context context, int n) {
        if (context == null) {
            return n;
        }
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"sys.settings_system_version", (int)n);
    }

    public static String getDeviceId(Context object) {
        if (object == null) {
            return null;
        }
        try {
            object = (TelephonyManager)object.getSystemService("phone");
            if (object == null) {
                return null;
            }
            if ((object = object.getDeviceId()) == null) {
                return null;
            }
            return ((String)object).trim();
        }
        catch (SecurityException securityException) {
            Log.e("MicroMsg.Util", "getDeviceId failed, security exception");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String getLine1Number(Context context) {
        if (context == null) {
            return null;
        }
        try {
            if ((TelephonyManager)context.getSystemService("phone") == null) {
                Log.e("MicroMsg.Util", "get line1 number failed, null tm");
                return null;
            }
        }
        catch (SecurityException securityException) {
            Log.e("MicroMsg.Util", "getLine1Number failed, security exception");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static boolean isLockScreen(Context context) {
        try {
            return ((KeyguardManager)context.getSystemService("keyguard")).inKeyguardRestrictedInputMode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isTopActivity(Context object) {
        String string = object.getClass().getName();
        object = Util.getTopActivityName((Context)object);
        Log.d("MicroMsg.Util", "top activity=" + (String)object + ", context=" + string);
        return ((String)object).equalsIgnoreCase(string);
    }

    public static boolean isServiceRunning(Context object, String string) {
        for (ActivityManager.RunningServiceInfo runningServiceInfo : ((ActivityManager)object.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (runningServiceInfo == null || runningServiceInfo.service == null || !runningServiceInfo.service.getClassName().toString().equals(string)) continue;
            Log.w("MicroMsg.Util", "service " + string + " is running");
            return true;
        }
        Log.w("MicroMsg.Util", "service " + string + " is not running");
        return false;
    }

    public static boolean isProcessRunning(Context object, String string) {
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : ((ActivityManager)object.getSystemService("activity")).getRunningAppProcesses()) {
            if (runningAppProcessInfo == null || runningAppProcessInfo.processName == null || !runningAppProcessInfo.processName.equals(string)) continue;
            Log.w("MicroMsg.Util", "process " + string + " is running");
            return true;
        }
        Log.w("MicroMsg.Util", "process " + string + " is not running");
        return false;
    }

    public static String getTopActivityName(Context context) {
        try {
            return ((ActivityManager.RunningTaskInfo)((ActivityManager)context.getSystemService((String)"activity")).getRunningTasks((int)1).get((int)0)).topActivity.getClassName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "(null)";
        }
    }

    public static boolean isTopApplication(Context object) {
        try {
            String string = ((ActivityManager.RunningTaskInfo)((ActivityManager)object.getSystemService((String)"activity")).getRunningTasks((int)1).get((int)0)).topActivity.getClassName();
            object = object.getPackageName();
            Log.d("MicroMsg.Util", "top activity=" + string + ", context=" + (String)object);
            return string.contains((CharSequence)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isIntentAvailable(Context context, Intent intent) {
        return context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    public static void freeBitmapMap(Map<String, Bitmap> map) {
        Iterator<Map.Entry<String, Bitmap>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Bitmap bitmap = iterator.next().getValue();
            if (bitmap == null) continue;
            bitmap.recycle();
        }
        map.clear();
    }

    public static void selectPicture(Context context, int n) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        intent = Intent.createChooser((Intent)intent, null);
        ((Activity)context).startActivityForResult(intent, n);
    }

    public static int nullAsNil(Integer n) {
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static long nullAsNil(Long l) {
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static String nullAsNil(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static boolean nullAsTrue(Boolean bl) {
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public static boolean nullAsFalse(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static int nullAs(Integer n, int n2) {
        if (n == null) {
            return n2;
        }
        return n;
    }

    public static long nullAs(Long l, long l2) {
        if (l == null) {
            return l2;
        }
        return l;
    }

    public static boolean nullAs(Boolean bl, boolean bl2) {
        if (bl == null) {
            return bl2;
        }
        return bl;
    }

    public static String nullAs(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }

    public static int nullAsInt(Object object, int n) {
        if (object == null) {
            return n;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        return n;
    }

    public static boolean isNullOrNil(String string) {
        return string == null || string.length() <= 0;
    }

    public static boolean isNullOrNil(byte[] byArray) {
        return byArray == null || byArray.length <= 0;
    }

    public static int getInt(String string, int n) {
        try {
            if (string == null) {
                return n;
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return n;
        }
    }

    public static long getLong(String string, long l) {
        try {
            if (string == null) {
                return l;
            }
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return l;
        }
    }

    public static int getHex(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return (int)(Long.decode(string) & 0xFFFFFFFFL);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> parseXml(String object, String object22, String string) {
        if (object == null || ((String)object).length() <= 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object2 = DocumentBuilderFactory.newInstance();
        try {
            object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        if (object2 == null) {
            Log.e("MicroMsg.Util", "new Document Builder failed");
            return null;
        }
        Document document = null;
        try {
            void var2_4;
            object = new InputSource(new ByteArrayInputStream(((String)object).getBytes()));
            if (var2_4 != null) {
                ((InputSource)object).setEncoding((String)var2_4);
            }
            document = ((DocumentBuilder)object2).parse((InputSource)object);
            document.normalize();
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (document == null) {
            Log.e("MicroMsg.Util", "new Document failed");
            return null;
        }
        object = document.getDocumentElement();
        if (object == null) {
            Log.e("MicroMsg.Util", "getDocumentElement failed");
            return null;
        }
        if (object22 != null && ((String)object22).equals(object.getNodeName())) {
            Util.a(hashMap, "", (Node)object, 0);
        } else {
            if ((object = object.getElementsByTagName((String)object22)).getLength() <= 0) {
                Log.e("MicroMsg.Util", "parse item null");
                return null;
            }
            if (object.getLength() > 1) {
                Log.w("MicroMsg.Util", "parse items more than one");
            }
            Util.a(hashMap, "", object.item(0), 0);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Log.v("MicroMsg.Util", "key=" + (String)entry.getKey() + " value=" + (String)entry.getValue());
        }
        return hashMap;
    }

    private static void a(Map<String, String> map, String string, Node node, int n) {
        Object object;
        if (node.getNodeName().equals("#text")) {
            map.put(string, node.getNodeValue());
            return;
        }
        if (node.getNodeName().equals("#cdata-section")) {
            map.put(string, node.getNodeValue());
            return;
        }
        string = string + "." + node.getNodeName() + (n > 0 ? Integer.valueOf(n) : "");
        map.put(string, node.getNodeValue());
        Object object2 = node.getAttributes();
        if (object2 != null) {
            for (int i = 0; i < object2.getLength(); ++i) {
                object = object2.item(i);
                map.put(string + ".$" + object.getNodeName(), object.getNodeValue());
            }
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            object2 = object.item(i);
            int n2 = Util.nullAsNil((Integer)hashMap.get(object2.getNodeName()));
            Util.a(map, string, (Node)object2, n2);
            hashMap.put(object2.getNodeName(), n2 + 1);
        }
    }

    public static void transClickToSelect(final View view, final View view2) {
        view.setOnTouchListener(new View.OnTouchListener(){

            public final boolean onTouch(View view3, MotionEvent motionEvent) {
                switch (motionEvent.getAction()) {
                    case 0: {
                        view2.setSelected(true);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        view2.setSelected(false);
                        break;
                    }
                    case 2: {
                        view2.setSelected(view.isPressed());
                    }
                }
                return false;
            }
        });
    }

    public static String getCutPasswordMD5(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() <= 16) {
            return Util.getFullPasswordMD5(string);
        }
        return Util.getFullPasswordMD5(string.substring(0, 16));
    }

    public static String getFullPasswordMD5(String string) {
        return MD5.getMessageDigest(string.getBytes());
    }

    public static Element getRootElementFromXML(byte[] object) {
        Object object2 = DocumentBuilderFactory.newInstance();
        try {
            object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        if (object2 == null) {
            Log.e("MicroMsg.Util", "new Document Builder failed");
            return null;
        }
        try {
            object = ((DocumentBuilder)object2).parse(new ByteArrayInputStream((byte[])object));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        if (object == null) {
            Log.e("MicroMsg.Util", "new Document failed");
            return null;
        }
        return object.getDocumentElement();
    }

    /*
     * Loose catch block
     */
    public static String convertStreamToString(InputStream inputStream) {
        StringBuilder stringBuilder;
        block11: {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            stringBuilder = new StringBuilder();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block11;
            catch (IOException iOException) {
                try {
                    iOException.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String encodeHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuilder.append(String.format("%02x", byArray[i] & 0xFF));
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] decodeHexString(String string) {
        if (string == null || string.length() <= 0) {
            return new byte[0];
        }
        try {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16) & 0xFF);
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return new byte[0];
        }
    }

    public static int guessHttpSendLength(int n) {
        return 224 + ((n - 1) / 1462 + 1) * 52 + n;
    }

    public static int guessHttpRecvLength(int n) {
        return 208 + ((n - 1) / 1462 + 1) * 52 + n;
    }

    public static int guessHttpContinueRecvLength(int n) {
        return 52 + ((n - 1) / 1462 + 1) * 52 + n;
    }

    public static int guessTcpConnectLength() {
        return 172;
    }

    public static int guessTcpDisconnectLength() {
        return 156;
    }

    public static int guessTcpSendLength(int n) {
        return 40 + ((n - 1) / 1462 + 1) * 52 + n;
    }

    public static int guessTcpRecvLength(int n) {
        return 40 + ((n - 1) / 1462 + 1) * 52 + n;
    }

    public static int[] splitToIntArray(String objectArray) {
        if (objectArray == null) {
            return null;
        }
        String[] stringArray = objectArray.split(":");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            if (string == null || string.length() <= 0) continue;
            try {
                int n2 = Integer.valueOf(string);
                arrayList.add(n2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.e("MicroMsg.Util", "invalid port num, ignore");
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    public static int UnZipFolder(String object, String string) {
        try {
            Object object2;
            android.util.Log.v((String)"XZip", (String)"UnZipFolder(String, String)");
            object = new ZipInputStream(new FileInputStream((String)object));
            while ((object2 = ((ZipInputStream)object).getNextEntry()) != null) {
                int n;
                String string2 = ((ZipEntry)object2).getName();
                if (((ZipEntry)object2).isDirectory()) {
                    string2 = string2.substring(0, string2.length() - 1);
                    new File(string + File.separator + string2).mkdirs();
                    continue;
                }
                object2 = new File(string + File.separator + string2);
                ((File)object2).createNewFile();
                object2 = new FileOutputStream((File)object2);
                byte[] byArray = new byte[1024];
                while ((n = ((FilterInputStream)object).read(byArray)) != -1) {
                    ((FileOutputStream)object2).write(byArray, 0, n);
                    ((OutputStream)object2).flush();
                }
                ((FileOutputStream)object2).close();
            }
            ((ZipInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return -1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -2;
        }
        return 0;
    }

    public static String getStack() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length < 2) {
            return "";
        }
        String string = "";
        for (int i = 1; i < stackTraceElementArray.length && stackTraceElementArray[i].getClassName().contains("com.tencent.mm"); ++i) {
            string = string + "[" + stackTraceElementArray[i].getClassName().substring(15) + ":" + stackTraceElementArray[i].getMethodName() + "]";
        }
        return string;
    }

    public static boolean checkSDCardFull() {
        Object object = Environment.getExternalStorageState();
        if (!"mounted".equals(object)) {
            return false;
        }
        object = Environment.getExternalStorageDirectory();
        object = new StatFs(((File)object).getPath());
        long l = object.getBlockCount();
        long l2 = object.getAvailableBlocks();
        if (l <= 0L) {
            return false;
        }
        if (l - l2 < 0L) {
            return false;
        }
        int n = (int)((l - l2) * 100L / l);
        long l3 = (long)object.getBlockSize() * (long)object.getFreeBlocks();
        Log.d("MicroMsg.Util", "checkSDCardFull per:" + n + " blockCount:" + l + " availCount:" + l2 + " availSize:" + l3);
        if (95 > n) {
            return false;
        }
        return l3 <= 0x3200000L;
    }

    public static String GetHostIp() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean checkPermission(Context context, String string) {
        Assert.assertNotNull((Object)context);
        String string2 = context.getPackageName();
        boolean bl = 0 == context.getPackageManager().checkPermission(string, string2);
        Log.d("MicroMsg.Util", string2 + " has " + (bl ? "permission " : "no permission ") + string);
        return bl;
    }

    public static boolean jump(Context context, String string) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        if (!Util.isIntentAvailable(context, intent)) {
            Log.e("MicroMsg.Util", "jump to url failed, " + string);
            return false;
        }
        context.startActivity(intent);
        return true;
    }

    public static String escapeStringForXml(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ' && c != bu[0] && c != bu[1] && c != bu[2] || c > '\u007f') {
                stringBuffer.append("&#");
                stringBuffer.append(Integer.toString(c));
                stringBuffer.append(';');
                continue;
            }
            boolean bl = true;
            for (int j = bv.length - 1; j >= 0; --j) {
                if (bv[j] != c) continue;
                bl = false;
                stringBuffer.append(bw[j]);
                break;
            }
            if (!bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String processXml(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return Util.expandEntities(string);
        }
        return string;
    }

    public static String expandEntities(String string) {
        int n = -1;
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = string.charAt(i);
            cArray[n3++] = n4;
            if (n4 == 38 && n == -1) {
                n = n3;
                continue;
            }
            if (n == -1 || Character.isLetter((char)n4) || Character.isDigit((char)n4) || n4 == 35) continue;
            if (n4 == 59) {
                n4 = Util.a(cArray, n, n3 - n - 1);
                if (n4 > 65535) {
                    cArray[n - 1] = (char)(((n4 -= 65536) >> 10) + 55296);
                    cArray[n] = (char)((n4 & 0x3FF) + 56320);
                    n3 = n + 1;
                } else if (n4 != 0) {
                    cArray[n - 1] = (char)n4;
                    n3 = n;
                }
                n = -1;
                continue;
            }
            n = -1;
        }
        return new String(cArray, 0, n3);
    }

    private static int a(char[] cArray, int n, int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (cArray[n] == '#') {
            if (n2 > 1 && (cArray[n + 1] == 'x' || cArray[n + 1] == 'X')) {
                try {
                    return Integer.parseInt(new String(cArray, n + 2, n2 - 2), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
            try {
                return Integer.parseInt(new String(cArray, n + 1, n2 - 1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        new String(cArray, n, n2);
        return 0;
    }

    public static boolean isImgFile(String string) {
        if (string == null || string.length() == 0) {
            Log.e("MicroMsg.Util", "isImgFile, invalid argument");
            return false;
        }
        if (string.length() < 3) {
            return false;
        }
        if (!new File(string).exists()) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        return options.outWidth > 0 && options.outHeight > 0;
    }

    /*
     * WARNING - void declaration
     */
    public static String mapToXml(String charSequence, LinkedHashMap<String, String> object) {
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("<key>");
        for (Map.Entry entry : ((LinkedHashMap)((Object)object)).entrySet()) {
            void object2;
            Object object3 = entry.getKey();
            Object v = entry.getValue();
            if (object3 == null) {
                object3 = "unknow";
            }
            if (v == null) {
                String string = "unknow";
            }
            ((StringBuilder)charSequence).append("<" + object3 + ">");
            ((StringBuilder)charSequence).append(object2);
            ((StringBuilder)charSequence).append("</" + object3 + ">");
        }
        ((StringBuilder)charSequence).append("</key>");
        return ((StringBuilder)charSequence).toString();
    }

    public static Map<String, String> parseIni(String stringArray) {
        if (stringArray == null || stringArray.length() <= 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : stringArray.split("\n")) {
            String[] stringArray2;
            if (string == null || string.length() <= 0 || (stringArray2 = string.trim().split("=", 2)) == null || stringArray2.length < 2) continue;
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (string2 == null || string2.length() <= 0 || !string2.matches("^[a-zA-Z0-9_]*")) continue;
            hashMap.put(string2, string3);
        }
        return hashMap;
    }
}

