/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.openapi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import com.tencent.mm.algorithm.MD5;
import com.tencent.mm.sdk.MMSharedPreferences;
import com.tencent.mm.sdk.channel.MMessage;
import com.tencent.mm.sdk.channel.MMessageAct;
import com.tencent.mm.sdk.openapi.BaseReq;
import com.tencent.mm.sdk.openapi.BaseResp;
import com.tencent.mm.sdk.openapi.GetMessageFromWX;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.sdk.openapi.SendAuth;
import com.tencent.mm.sdk.openapi.SendMessageToWX;
import com.tencent.mm.sdk.openapi.ShowMessageFromWX;
import com.tencent.mm.sdk.platformtools.Log;

final class WXApiImplV10
implements IWXAPI {
    private Context R;
    private String S;
    private boolean T = false;

    protected WXApiImplV10(Context context, String string) {
        this(context, string, false);
    }

    protected WXApiImplV10(Context context, String string, boolean bl) {
        this.R = context;
        this.S = string;
        this.T = bl;
    }

    public final boolean registerApp(String string) {
        if (!this.a("com.tencent.mm")) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "register app failed for wechat app signature check failed");
            return false;
        }
        if (string != null) {
            this.S = string;
        }
        Log.d("MicroMsg.SDK.WXApiImplV10", "register app " + this.R.getPackageName());
        MMessage.send(this.R, "com.tencent.mm", "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER", "weixin://registerapp?appid=" + this.S);
        return true;
    }

    public final void unregisterApp() {
        if (!this.a("com.tencent.mm")) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "unregister app failed for wechat app signature check failed");
            return;
        }
        if (this.S == null || this.S.length() == 0) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "unregisterApp fail, appId is empty");
            return;
        }
        Log.d("MicroMsg.SDK.WXApiImplV10", "unregister app " + this.R.getPackageName());
        MMessage.send(this.R, "com.tencent.mm", "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_UNREGISTER", "weixin://unregisterapp?appid=" + this.S);
    }

    public final boolean handleIntent(Intent object, IWXAPIEventHandler iWXAPIEventHandler) {
        String string;
        Object object2 = object;
        if (!(object2 == null ? false : (string = object2.getStringExtra("wx_token_key")) != null && string.equals("com.tencent.mm.openapi.token"))) {
            return false;
        }
        object2 = object.getStringExtra("_mmessage_content");
        int n = object.getIntExtra("_mmessage_sdkVersion", 0);
        string = object.getStringExtra("_mmessage_appPackage");
        if (string == null || string.length() == 0) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "invalid argument");
            return false;
        }
        byte[] byArray = object.getByteArrayExtra("_mmessage_checksum");
        StringBuffer stringBuffer = new StringBuffer();
        if (object2 != null) {
            stringBuffer.append((String)object2);
        }
        stringBuffer.append(n);
        stringBuffer.append(string);
        stringBuffer.append("mMcShCsTr");
        object2 = MD5.getMessageDigest(stringBuffer.toString().substring(1, 9).getBytes()).getBytes();
        if (!WXApiImplV10.a(byArray, (byte[])object2)) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "checksum fail");
            return false;
        }
        switch (object.getIntExtra("_wxapi_command_type", 0)) {
            case 1: {
                object = new SendAuth.Resp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 2: {
                object = new SendMessageToWX.Resp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 3: {
                object = new GetMessageFromWX.Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
            case 4: {
                object = new ShowMessageFromWX.Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
        }
        return false;
    }

    public final boolean isWXAppInstalled() {
        try {
            PackageInfo packageInfo = this.R.getPackageManager().getPackageInfo("com.tencent.mm", 64);
            if (packageInfo == null) {
                return false;
            }
            return this.a(packageInfo.signatures);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public final boolean isWXAppSupportAPI() {
        return this.getWXAppSupportAPI() >= 553844737;
    }

    public final int getWXAppSupportAPI() {
        if (!this.isWXAppInstalled()) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "open wx app failed, not installed or signature check failed");
            return 0;
        }
        return new MMSharedPreferences(this.R).getInt("_build_info_sdk_int_", 0);
    }

    public final boolean openWXApp() {
        if (!this.isWXAppInstalled()) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "open wx app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.R.startActivity(this.R.getPackageManager().getLaunchIntentForPackage("com.tencent.mm"));
        }
        catch (Exception exception) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "startActivity fail, exception = " + exception.getMessage());
            return false;
        }
        return true;
    }

    public final boolean sendReq(BaseReq baseReq) {
        if (!this.a("com.tencent.mm")) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "sendReq failed for wechat app signature check failed");
            return false;
        }
        if (!baseReq.checkArgs()) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "sendReq checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        baseReq.toBundle(bundle);
        return MMessageAct.sendToWx(this.R, "weixin://sendreq?appid=" + this.S, bundle);
    }

    public final boolean sendResp(BaseResp baseResp) {
        if (!this.a("com.tencent.mm")) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "sendResp failed for wechat app signature check failed");
            return false;
        }
        if (!baseResp.checkArgs()) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "sendResp checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        baseResp.toBundle(bundle);
        return MMessageAct.sendToWx(this.R, "weixin://sendresp?appid=" + this.S, bundle);
    }

    private boolean a(String string) {
        if (!this.T) {
            Log.d("MicroMsg.SDK.WXApiImplV10", "ignore wechat app signature validation");
            return true;
        }
        try {
            string = this.R.getPackageManager().getPackageInfo(string, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        return this.a(((PackageInfo)string).signatures);
    }

    private boolean a(Signature[] signatureArray) {
        if (!this.T) {
            Log.d("MicroMsg.SDK.WXApiImplV10", "ignore wechat app signature validation");
            return true;
        }
        int n = signatureArray.length;
        for (int i = 0; i < n; ++i) {
            String string = signatureArray[i].toCharsString();
            Log.d("MicroMsg.SDK.WXApiImplV10", "check signature:" + string);
            if (!string.equals("308202eb30820254a00302010202044d36f7a4300d06092a864886f70d01010505003081b9310b300906035504061302383631123010060355040813094775616e67646f6e673111300f060355040713085368656e7a68656e31353033060355040a132c54656e63656e7420546563686e6f6c6f6779285368656e7a68656e2920436f6d70616e79204c696d69746564313a3038060355040b133154656e63656e74204775616e677a686f7520526573656172636820616e6420446576656c6f706d656e742043656e7465723110300e0603550403130754656e63656e74301e170d3131303131393134333933325a170d3431303131313134333933325a3081b9310b300906035504061302383631123010060355040813094775616e67646f6e673111300f060355040713085368656e7a68656e31353033060355040a132c54656e63656e7420546563686e6f6c6f6779285368656e7a68656e2920436f6d70616e79204c696d69746564313a3038060355040b133154656e63656e74204775616e677a686f7520526573656172636820616e6420446576656c6f706d656e742043656e7465723110300e0603550403130754656e63656e7430819f300d06092a864886f70d010101050003818d0030818902818100c05f34b231b083fb1323670bfbe7bdab40c0c0a6efc87ef2072a1ff0d60cc67c8edb0d0847f210bea6cbfaa241be70c86daf56be08b723c859e52428a064555d80db448cdcacc1aea2501eba06f8bad12a4fa49d85cacd7abeb68945a5cb5e061629b52e3254c373550ee4e40cb7c8ae6f7a8151ccd8df582d446f39ae0c5e930203010001300d06092a864886f70d0101050500038181009c8d9d7f2f908c42081b4c764c377109a8b2c70582422125ce545842d5f520aea69550b6bd8bfd94e987b75a3077eb04ad341f481aac266e89d3864456e69fba13df018acdc168b9a19dfd7ad9d9cc6f6ace57c746515f71234df3a053e33ba93ece5cd0fc15f3e389a3f365588a9fcb439e069d3629cd7732a13fff7b891499")) continue;
            Log.d("MicroMsg.SDK.WXApiImplV10", "pass");
            return true;
        }
        return false;
    }

    private static boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "checkSumConsistent fail, invalid arguments");
            return false;
        }
        if (byArray.length != byArray2.length) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "checkSumConsistent fail, length is different");
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

