/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUMap<K, O> {
    private Map<K, TimeVal<O>> c = null;
    private int d;
    private int e;
    private PreRemoveCallback<K, O> f = null;

    public LRUMap(int n) {
        this(n, null);
    }

    public LRUMap(int n, PreRemoveCallback<K, O> preRemoveCallback) {
        this.d = n;
        this.e = 0;
        this.f = preRemoveCallback;
        this.c = new HashMap<K, TimeVal<O>>();
    }

    public int size() {
        return this.c.size();
    }

    public void setMaxSize(int n) {
        if (n > 0) {
            this.d = n;
        }
    }

    public void setPerDeleteSize(int n) {
        if (n > 0) {
            this.e = n;
        }
    }

    public boolean check(K k) {
        return this.c.containsKey(k);
    }

    public boolean checkAndUpTime(K k) {
        if (this.c.containsKey(k)) {
            this.c.get(k).UpTime();
            return true;
        }
        return false;
    }

    public O get(K object) {
        if ((object = this.c.get(object)) == null) {
            return null;
        }
        return (O)((TimeVal)object).obj;
    }

    public O getAndUptime(K k) {
        TimeVal<O> timeVal = this.c.get(k);
        if (timeVal == null) {
            return null;
        }
        this.c.get(k).UpTime();
        return (O)timeVal.obj;
    }

    public void remove(K k) {
        if (!this.c.containsKey(k)) {
            return;
        }
        if (this.f != null) {
            this.f.preRemoveCallback(k, this.c.get(k).obj);
        }
        this.c.remove(k);
    }

    public void clear() {
        this.c.clear();
    }

    public void clear(OnClearListener<K, O> onClearListener) {
        if (this.c != null) {
            if (onClearListener != null) {
                for (Map.Entry<K, TimeVal<O>> entry : this.c.entrySet()) {
                    onClearListener.onClear(entry.getKey(), entry.getValue().obj);
                }
            }
            this.c.clear();
        }
    }

    public void update(K object, O object2) {
        if (this.c.get(object) == null) {
            Object object3 = object2;
            object2 = object;
            object = this;
            object3 = (LRUMap)object.new TimeVal<O>(object3);
            ((LRUMap)object).c.put((O)object2, (TimeVal<O>)object3);
            if (((LRUMap)object).c.size() > ((LRUMap)object).d) {
                int n;
                object2 = new ArrayList<Map.Entry<K, TimeVal<O>>>(((LRUMap)object).c.entrySet());
                Collections.sort(object2, new Comparator<Map.Entry<K, TimeVal<O>>>(){

                    @Override
                    public int compare(Map.Entry<K, TimeVal<O>> entry, Map.Entry<K, TimeVal<O>> entry2) {
                        return entry.getValue().t.compareTo(entry2.getValue().t);
                    }
                });
                object3 = object;
                n = ((LRUMap)object3).e <= 0 ? ((n = ((LRUMap)object3).d / 10) <= 0 ? 1 : n) : ((LRUMap)object3).e;
                object2 = ((ArrayList)object2).iterator();
                while (object2.hasNext()) {
                    Map.Entry entry = (Map.Entry)object2.next();
                    ((LRUMap)object).remove(entry.getKey());
                    if (--n > 0) continue;
                }
            }
            return;
        }
        this.c.get(object).UpTime();
        this.c.get(object).obj = object2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnClearListener<K, O> {
        public void onClear(K var1, O var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PreRemoveCallback<K, O> {
        public void preRemoveCallback(K var1, O var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TimeVal<OO> {
        public OO obj;
        public Long t;

        public TimeVal(OO OO) {
            this.obj = OO;
            this.UpTime();
        }

        public void UpTime() {
            this.t = System.currentTimeMillis();
        }
    }
}

