/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vi.db;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.baidu.vi.db.SQLiteStatement4C;

public class SQLiteDatabase4C {
    private static SQLiteDatabase a;

    public static SQLiteDatabase getSQLiteDatabase() {
        return a;
    }

    public static boolean openDB(String string) {
        a = SQLiteDatabase.openOrCreateDatabase((String)string, null);
        return a.isOpen();
    }

    public static boolean closeDB() {
        if (SQLiteDatabase4C.isDBExists()) {
            a.close();
        } else {
            Log.d((String)"VI_WARNING", (String)"database is not open before closed");
        }
        return true;
    }

    public static boolean isDBExists() {
        return a != null;
    }

    public static boolean isTableExists(String string) {
        Cursor cursor = a.query("sqlite_master", new String[]{"[sql]"}, "[type] = 'table' and name = ?", new String[]{string}, null, null, null);
        return cursor.getCount() == 1;
    }

    public static SQLiteStatement4C compileStatement(String string) {
        if (a.isOpen()) {
            return new SQLiteStatement4C(a, string);
        }
        Log.d((String)"VI_WARNING", (String)"Can not compile statement, because database is not open");
        return null;
    }

    public static boolean transactionBegin() {
        try {
            a.execSQL("BEGIN EXCLUSIVE;");
            return true;
        }
        catch (SQLException sQLException) {
            Log.d((String)"VI_ERROR", (String)sQLException.getMessage());
            return false;
        }
    }

    public static boolean transactionCommit() {
        try {
            a.execSQL("COMMIT;");
            return true;
        }
        catch (SQLException sQLException) {
            Log.d((String)"VI_ERROR", (String)sQLException.getMessage());
            return false;
        }
    }

    public static boolean transactionRollback() {
        try {
            a.execSQL("ROLLBACK;");
            return true;
        }
        catch (SQLException sQLException) {
            Log.d((String)"VI_ERROR", (String)sQLException.getMessage());
            return false;
        }
    }

    public static boolean isThreadSafe() {
        Log.d((String)"VI_INFO", (String)"Sqlite is always thread safe in Android OS");
        return true;
    }
}

