/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vi;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.DisplayMetrics;
import android.webkit.MimeTypeMap;
import com.baidu.vi.f;
import com.baidu.vi.g;
import com.baidu.vi.h;
import com.baidu.vi.j;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class VDeviceAPI {
    private static PowerManager.WakeLock a = null;
    private static BroadcastReceiver b = null;

    public static long getTotalSpace() {
        File file = Environment.getRootDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l2 * l3 / 1024L;
    }

    public static long getFreeSpace() {
        File file = Environment.getRootDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l2 * l3 / 1024L;
    }

    public static long getSdcardTotalSpace() {
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l2 * l3 / 1024L;
    }

    public static long getSdcardFreeSpace() {
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l2 * l3 / 1024L;
    }

    public static long getTotalMemory() {
        String string = "/proc/meminfo";
        long l2 = 0L;
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader, 8192);
            String string2 = bufferedReader.readLine();
            String[] stringArray = string2.split("\\s+");
            l2 = Integer.valueOf(stringArray[1]).intValue();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l2;
    }

    public static long getAvailableMemory() {
        ActivityManager activityManager = (ActivityManager)h.a().getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem / 1024L;
    }

    public static String getOsVersion() {
        return "android";
    }

    public static void setupSoftware(String string) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)new File(string)), "application/vnd.android.package-archive");
        h.a().startActivity(intent);
    }

    public static String getModuleFileName() {
        return h.a().getFilesDir().getAbsolutePath();
    }

    public static String getSdcardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static String getCachePath() {
        return Environment.getDataDirectory().getAbsolutePath();
    }

    public static String getAppVersion() {
        String string = h.a().getApplicationInfo().packageName;
        try {
            return h.a().getPackageManager().getPackageInfo((String)string, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static int getCurrentNetworkType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)h.a().getSystemService("connectivity");
        if (connectivityManager.getActiveNetworkInfo() == null) {
            return 0;
        }
        int n2 = connectivityManager.getActiveNetworkInfo().getType();
        switch (n2) {
            case 1: {
                return 2;
            }
            case 0: {
                return 3;
            }
        }
        return 1;
    }

    public static boolean isWifiConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)h.a().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        return networkInfo.isConnected();
    }

    public static j getNetworkInfo(int n2) {
        ConnectivityManager connectivityManager = (ConnectivityManager)h.a().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        switch (n2) {
            case 2: {
                networkInfo = connectivityManager.getNetworkInfo(1);
                break;
            }
            case 3: {
                networkInfo = connectivityManager.getNetworkInfo(0);
                break;
            }
        }
        if (networkInfo != null) {
            return new j(networkInfo);
        }
        return new j(networkInfo);
    }

    public static void setNetworkChangedCallback() {
        VDeviceAPI.unsetNetworkChangedCallback();
        b = new f();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        h.a().registerReceiver(b, intentFilter);
    }

    public static void unsetNetworkChangedCallback() {
        if (b != null) {
            h.a().unregisterReceiver(b);
            b = null;
        }
    }

    public static native void onNetworkStateChanged();

    public static ScanResult[] getWifiHotpot() {
        WifiManager wifiManager = (WifiManager)h.a().getSystemService("wifi");
        List list = wifiManager.getScanResults();
        int n2 = list.size();
        ScanResult[] scanResultArray = new ScanResult[n2];
        return list.toArray(scanResultArray);
    }

    public static float getSystemMetricsX() {
        if (g.a() == null) {
            return 0.0f;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        g.a().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static float getSystemMetricsY() {
        if (g.a() == null) {
            return 0.0f;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        g.a().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public static float getScreenDensity() {
        if (g.a() == null) {
            return 0.0f;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        g.a().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.density;
    }

    public static int getScreenDensityDpi() {
        if (g.a() == null) {
            return 0;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        g.a().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.densityDpi;
    }

    public static void setScreenAlwaysOn(boolean bl) {
        if (bl) {
            if (a == null) {
                PowerManager powerManager = (PowerManager)h.a().getSystemService("power");
                a = powerManager.newWakeLock(10, "VDeviceAPI");
            }
            a.acquire();
        } else if (a != null && a.isHeld()) {
            a.release();
            a = null;
        }
    }

    public static int getScreenBrightness() {
        ContentResolver contentResolver = h.a().getContentResolver();
        int n2 = 0;
        try {
            n2 = Settings.System.getInt((ContentResolver)contentResolver, (String)"screen_brightness_mode");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            settingNotFoundException.printStackTrace();
        }
        if (n2 == 1) {
            return -1;
        }
        String string = "screen_brightness";
        int n3 = 0;
        try {
            n3 = Settings.System.getInt((ContentResolver)contentResolver, (String)string);
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return -1;
        }
        return n3;
    }

    public static void makeCall(String string) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + string)));
        h.a().startActivity(intent);
    }

    public static void sendSMS(String string, String string2) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)("smsto:" + string)));
        intent.putExtra("sms_body", string2);
        h.a().startActivity(intent);
    }

    public static int sendMMS(String string, String string2, String string3, String string4) {
        File file;
        if (!PhoneNumberUtils.isWellFormedSmsAddress((String)string)) {
            return 1;
        }
        String string5 = null;
        try {
            file = new File(string4);
            String string6 = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)file).toString());
            string5 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string6);
        }
        catch (Exception exception) {
            return 2;
        }
        file = new Intent("android.intent.action.SEND");
        file.putExtra("address", string);
        file.putExtra("subject", string2);
        file.putExtra("sms_body", string3);
        file.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)("file://" + string4)));
        file.setType(string5);
        h.a().startActivity((Intent)file);
        return 0;
    }

    public static void openUrl(String string) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        h.a().startActivity(intent);
    }

    public static String getCellId() {
        TelephonyManager telephonyManager = (TelephonyManager)h.a().getSystemService("phone");
        if (telephonyManager == null) {
            return null;
        }
        CellLocation cellLocation = telephonyManager.getCellLocation();
        if (cellLocation instanceof GsmCellLocation) {
            return " " + ((GsmCellLocation)cellLocation).getCid();
        }
        return " ";
    }

    public static String getLac() {
        TelephonyManager telephonyManager = (TelephonyManager)h.a().getSystemService("phone");
        if (telephonyManager == null) {
            return null;
        }
        CellLocation cellLocation = telephonyManager.getCellLocation();
        if (cellLocation instanceof GsmCellLocation) {
            return "" + ((GsmCellLocation)cellLocation).getLac();
        }
        return "";
    }

    public static String getImei() {
        TelephonyManager telephonyManager = (TelephonyManager)h.a().getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getDeviceId();
        }
        return null;
    }

    public static String getImsi() {
        TelephonyManager telephonyManager = (TelephonyManager)h.a().getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getSubscriberId();
        }
        return null;
    }
}

