/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayItem;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemizedOverlay<Item extends OverlayItem>
extends Overlay
implements Comparator<Integer> {
    private ArrayList<OverlayItem> a;
    private ArrayList<Integer> b;
    private Drawable c;

    public ItemizedOverlay(Drawable drawable) {
        this.mType = 27;
        this.c = drawable;
    }

    protected static void boundCenterBottom(OverlayItem overlayItem) {
        overlayItem.a(1);
    }

    protected static void boundCenter(OverlayItem overlayItem) {
        overlayItem.a(2);
    }

    protected ArrayList<OverlayItem> getAllItem() {
        return this.a;
    }

    public final OverlayItem getItem(int n2) {
        if (this.a != null && this.a.size() > n2) {
            return this.a.get(n2);
        }
        return null;
    }

    public int getLatSpanE6() {
        return this.a(true);
    }

    public int getLonSpanE6() {
        return this.a(false);
    }

    public GeoPoint getCenter() {
        int n2 = this.getIndexToDraw(0);
        return this.getItem(n2).getPoint();
    }

    private int a(boolean bl) {
        if (this.a.size() == 0) {
            return 0;
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        Iterator<OverlayItem> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            int n4;
            GeoPoint geoPoint = iterator.next().getPoint();
            int n5 = n4 = bl ? geoPoint.getLatitudeE6() : geoPoint.getLongitudeE6();
            if (n4 > n2) {
                n2 = n4;
            }
            if (n4 >= n3) continue;
            n3 = n4;
        }
        return n2 - n3;
    }

    protected int getIndexToDraw(int n2) {
        return this.b.get(n2);
    }

    protected boolean hitTest(OverlayItem overlayItem, Drawable drawable, int n2, int n3) {
        Rect rect = drawable.getBounds();
        int n4 = 10;
        rect.left -= n4;
        rect.right += n4;
        rect.bottom += n4;
        rect.top -= n4;
        boolean bl = rect.contains(n2, n3);
        rect.left += n4;
        rect.right -= n4;
        rect.bottom -= n4;
        rect.top += n4;
        return bl;
    }

    protected boolean onTap(int n2) {
        return false;
    }

    public boolean onTap(GeoPoint geoPoint, MapView mapView) {
        return false;
    }

    protected final void populate() {
        int n2 = this.size();
        if (this.b != null) {
            this.b.clear();
            this.b = null;
        }
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.a = new ArrayList(n2);
        this.b = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.b.add(i2, i2);
            Item Item = this.createItem(i2);
            if (((OverlayItem)Item).getMarker() == null) {
                ((OverlayItem)Item).setMarker(this.c);
            }
            this.a.add(i2, (OverlayItem)Item);
        }
        Collections.sort(this.b, this);
    }

    @Override
    public int compare(Integer n2, Integer n3) {
        GeoPoint geoPoint = this.a.get(n2).getPoint();
        GeoPoint geoPoint2 = this.a.get(n3).getPoint();
        if (geoPoint.getLatitudeE6() > geoPoint2.getLatitudeE6()) {
            return -1;
        }
        if (geoPoint.getLatitudeE6() < geoPoint2.getLatitudeE6()) {
            return 1;
        }
        if (geoPoint.getLongitudeE6() < geoPoint2.getLongitudeE6()) {
            return -1;
        }
        return geoPoint.getLongitudeE6() == geoPoint2.getLongitudeE6() ? 0 : 1;
    }

    protected abstract Item createItem(int var1);

    public abstract int size();
}

