/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.appsearch.patchupdate;

import com.baidu.appsearch.patchupdate.MD5;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class MD5InputStream
extends FilterInputStream {
    private MD5 md5 = new MD5();

    public MD5InputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        if ((n & 0xFFFFFF00) != 0) {
            System.out.println("MD5InputStream.read() got character with (c & ~0xff) != 0)!");
        } else {
            this.md5.update(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            return n3;
        }
        this.md5.update(byArray, n, n3);
        return n3;
    }

    public byte[] hash() {
        return this.md5.finalEncode();
    }

    public MD5 getMD5() {
        return this.md5;
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[stringArray.length - 1];
            boolean bl = false;
            boolean bl2 = true;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].equals("--use-default-md5")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[i].equals("--no-native-lib")) continue;
                bl2 = false;
            }
            byte[] byArray = new byte[65536];
            if (bl) {
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                    messageDigest.update(byArray, 0, n);
                }
                System.out.println(MD5.asHex(messageDigest.digest()) + "  " + string);
                ((InputStream)bufferedInputStream).close();
            } else {
                int n;
                if (!bl2) {
                    MD5.initNativeLibrary(true);
                }
                MD5InputStream mD5InputStream = new MD5InputStream(new BufferedInputStream(new FileInputStream(string)));
                while ((n = mD5InputStream.read(byArray)) != -1) {
                }
                System.out.println(MD5.asHex(mD5InputStream.hash()) + "  " + string);
                mD5InputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

