/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.common.util;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.baidu.android.common.logging.Log;
import com.baidu.android.common.security.AESUtil;
import com.baidu.android.common.security.Base64;
import com.baidu.android.common.security.MD5Util;
import com.baidu.android.common.security.SHA1Util;
import com.baidu.android.common.util.CuidCertStore;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceId {
    private static final String TAG = "DeviceId";
    private static final boolean DEBUG = false;
    private static final String KEY_DEVICE_ID = "com.baidu.deviceid";
    private static final String KEY_DEVICE_ID_V2 = "com.baidu.deviceid.v2";
    private static final String AES_KEY = "30212102dicudiab";
    private static final String OLD_EXT_DIR = "baidu";
    private static final String EXT_DIR = "backups/.SystemConfig";
    private static final String EXT_FILE = ".cuid";
    private static final String EXT_FILE_V2 = ".cuid2";
    private final Context mContext;
    private int mSaveMask = 0;
    private static final String RSA_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private PublicKey mPublicKey;
    private static final int STORAGE_SYSTEM_SETTING_V1 = 1;
    private static final int STORAGE_SYSTEM_SETTING_V2 = 2;
    private static final int STORAGE_SDCARD_V1 = 4;
    private static final int STORAGE_SDCARD_V2 = 8;
    private static final int STORAGE_SELF_FILE = 16;
    private static final String SELF_CUID_FILE = "libcuid.so";
    private static CUIDInfo sCachedCuidInfo;
    private static final String KEY_IMEI = "bd_setting_i";
    private static final String DEFAULT_TM_DEVICEID = "";
    private static final int SDK_ANDROID_M = 23;
    private static final String ACTION_GLAXY_CUID = "com.baidu.intent.action.GALAXY";
    private static final String META_KEY_GLAXY_DATA = "galaxy_data";
    private static final String META_KEY_GALAXY_SF = "galaxy_sf";

    private DeviceId(Context context) {
        this.mContext = context.getApplicationContext();
        this.initPublicKey();
    }

    private static String byte2hex(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String string = DEFAULT_TM_DEVICEID;
        String string2 = DEFAULT_TM_DEVICEID;
        for (int i = 0; i < byArray.length; ++i) {
            string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string2.length() == 1 ? string + "0" + string2 : string + string2;
        }
        return string.toLowerCase();
    }

    private String[] formatAndroidSigArray(Signature[] signatureArray) {
        String[] stringArray = new String[signatureArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = DeviceId.byte2hex(SHA1Util.sha1(signatureArray[i].toByteArray()));
        }
        return stringArray;
    }

    private static byte[] decryptByPublicKey(byte[] byArray, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, publicKey);
        return cipher.doFinal(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPublicKey() {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(CuidCertStore.getCertBytes());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            this.mPublicKey = certificate.getPublicKey();
        }
        catch (Exception exception) {
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {
                    DeviceId.handleThrowable(exception);
                }
            }
        }
    }

    private List<CUIDBuddyInfo> collectBuddyInfos(Intent intent, boolean bl) {
        ArrayList<CUIDBuddyInfo> arrayList = new ArrayList<CUIDBuddyInfo>();
        PackageManager packageManager = this.mContext.getPackageManager();
        List list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null) {
            for (ResolveInfo resolveInfo : list) {
                if (resolveInfo.activityInfo == null || resolveInfo.activityInfo.applicationInfo == null) continue;
                try {
                    String string;
                    String string2;
                    ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name), 128);
                    Bundle bundle = activityInfo.metaData;
                    if (bundle == null || TextUtils.isEmpty((CharSequence)(string2 = bundle.getString(META_KEY_GLAXY_DATA)))) continue;
                    byte[] byArray = Base64.decode(string2.getBytes("utf-8"));
                    String string3 = new String(byArray);
                    JSONObject jSONObject = new JSONObject(string3);
                    CUIDBuddyInfo cUIDBuddyInfo = new CUIDBuddyInfo();
                    cUIDBuddyInfo.priority = jSONObject.getInt("priority");
                    cUIDBuddyInfo.appInfo = resolveInfo.activityInfo.applicationInfo;
                    if (this.mContext.getPackageName().equals(resolveInfo.activityInfo.applicationInfo.packageName)) {
                        cUIDBuddyInfo.isSelf = true;
                    }
                    if (bl && !TextUtils.isEmpty((CharSequence)(string = bundle.getString(META_KEY_GALAXY_SF)))) {
                        PackageInfo packageInfo = packageManager.getPackageInfo(resolveInfo.activityInfo.applicationInfo.packageName, 64);
                        JSONArray jSONArray = jSONObject.getJSONArray("sigs");
                        String[] stringArray = new String[jSONArray.length()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = jSONArray.getString(i);
                        }
                        String[] stringArray2 = this.formatAndroidSigArray(packageInfo.signatures);
                        if (this.isSigsEqual(stringArray, stringArray2)) {
                            boolean bl2;
                            byte[] byArray2 = DeviceId.decryptByPublicKey(Base64.decode(string.getBytes()), this.mPublicKey);
                            byte[] byArray3 = SHA1Util.sha1(byArray);
                            boolean bl3 = bl2 = byArray2 != null && Arrays.equals(byArray2, byArray3);
                            if (bl2) {
                                cUIDBuddyInfo.sigMatched = true;
                            }
                        }
                    }
                    arrayList.add(cUIDBuddyInfo);
                }
                catch (Exception exception) {}
            }
        }
        Collections.sort(arrayList, new Comparator<CUIDBuddyInfo>(){

            @Override
            public int compare(CUIDBuddyInfo cUIDBuddyInfo, CUIDBuddyInfo cUIDBuddyInfo2) {
                int n = cUIDBuddyInfo2.priority - cUIDBuddyInfo.priority;
                if (n == 0) {
                    if (cUIDBuddyInfo.isSelf && cUIDBuddyInfo2.isSelf) {
                        return 0;
                    }
                    if (cUIDBuddyInfo.isSelf) {
                        return -1;
                    }
                    if (cUIDBuddyInfo2.isSelf) {
                        return 1;
                    }
                }
                return n;
            }
        });
        return arrayList;
    }

    private boolean isSigsEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            hashSet.add(string);
        }
        HashSet hashSet2 = new HashSet();
        for (String string : stringArray2) {
            hashSet2.add(string);
        }
        return hashSet.equals(hashSet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToCuidFile(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = this.mContext.openFileOutput(SELF_CUID_FILE, 1);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    DeviceId.handleThrowable(exception);
                }
            }
        }
        return false;
    }

    private String getSystemSettingValue(String string) {
        try {
            return Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)string);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return null;
        }
    }

    private boolean tryPutSystemSettingValue(String string, String string2) {
        try {
            return Settings.System.putString((ContentResolver)this.mContext.getContentResolver(), (String)string, (String)string2);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return false;
        }
    }

    private static void handleThrowable(Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            DeviceId.handleThrowable(iOException);
        }
        catch (SecurityException securityException) {
            DeviceId.handleThrowable(securityException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DeviceId.handleThrowable(iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(File file) {
        FileReader fileReader = null;
        try {
            int n;
            fileReader = new FileReader(file);
            char[] cArray = new char[8192];
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            while ((n = fileReader.read(cArray)) > 0) {
                charArrayWriter.write(cArray, 0, n);
            }
            String string = charArrayWriter.toString();
            return string;
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {
                    DeviceId.handleThrowable(exception);
                }
            }
        }
        return null;
    }

    public static String getCUID(Context context) {
        return DeviceId.getOrCreateCUIDInfo(context).getFinalCUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CUIDInfo getOrCreateCUIDInfo(Context context) {
        if (sCachedCuidInfo != null) return sCachedCuidInfo;
        Class<CUIDInfo> clazz = CUIDInfo.class;
        synchronized (CUIDInfo.class) {
            if (sCachedCuidInfo != null) return sCachedCuidInfo;
            long l = SystemClock.uptimeMillis();
            sCachedCuidInfo = new DeviceId(context).getCUIDInfo();
            long l2 = SystemClock.uptimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sCachedCuidInfo;
        }
    }

    public static String getDeviceID(Context context) {
        return DeviceId.getOrCreateCUIDInfo((Context)context).deviceId;
    }

    public static String getIMEI(Context context) {
        return DeviceId.getOrCreateCUIDInfo((Context)context).imei;
    }

    public static String getAndroidId(Context context) {
        String string = DEFAULT_TM_DEVICEID;
        string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = DEFAULT_TM_DEVICEID;
        }
        return string;
    }

    private CUIDInfo getCUIDInfo() {
        File file;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        File file2;
        int n;
        boolean bl3;
        CUIDInfo cUIDInfo = null;
        String string = null;
        List<CUIDBuddyInfo> list = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID).setPackage(this.mContext.getPackageName()), true);
        if (list == null || list.size() == 0) {
            bl3 = false;
            for (int i = 0; i < 3; ++i) {
                Log.w(TAG, "galaxy lib host missing meta-data,make sure you know the right way to integrate galaxy");
            }
        } else {
            CUIDBuddyInfo cUIDBuddyInfo = list.get(0);
            bl3 = cUIDBuddyInfo.sigMatched;
            if (!cUIDBuddyInfo.sigMatched) {
                for (n = 0; n < 3; ++n) {
                    Log.w(TAG, "galaxy config err, In the release version of the signature should be matched");
                }
            }
        }
        if ((file2 = new File(this.mContext.getFilesDir(), SELF_CUID_FILE)).exists()) {
            cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(file2)));
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 0x10;
            List<CUIDBuddyInfo> list2 = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID), bl3);
            if (list2 != null) {
                String string2 = "files";
                object2 = this.mContext.getFilesDir();
                if (!string2.equals(((File)object2).getName())) {
                    Log.e(TAG, "fetal error:: app files dir name is unexpectedly :: " + ((File)object2).getAbsolutePath());
                    string2 = ((File)object2).getName();
                }
                for (CUIDBuddyInfo object3 : list2) {
                    File file3;
                    if (object3.isSelf || !(file3 = new File(new File(object3.appInfo.dataDir, string2), SELF_CUID_FILE)).exists() || (cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(file3)))) == null) continue;
                    break;
                }
            }
        }
        if (cUIDInfo == null) {
            cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(this.getSystemSettingValue(KEY_DEVICE_ID_V2)));
        }
        n = this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") ? 1 : 0;
        if (cUIDInfo == null && n != 0) {
            this.mSaveMask |= 2;
            cUIDInfo = this.getCuidInfoFromExternalV2();
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 8;
            cUIDInfo = this.getCUidInfoFromSystemSettingV1();
        }
        boolean bl4 = false;
        if (cUIDInfo == null && n != 0) {
            this.mSaveMask |= 1;
            string = this.getIMEIFromSystem(DEFAULT_TM_DEVICEID);
            bl4 = true;
            cUIDInfo = this.getExternalV1DeviceId(string);
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 4;
            if (!bl4) {
                string = this.getIMEIFromSystem(DEFAULT_TM_DEVICEID);
            }
            cUIDInfo = new CUIDInfo();
            object2 = DeviceId.getAndroidId(this.mContext);
            if (Build.VERSION.SDK_INT < 23) {
                String bl22 = UUID.randomUUID().toString();
                object = string + (String)object2 + bl22;
            } else {
                object = "com.baidu" + (String)object2;
            }
            cUIDInfo.deviceId = MD5Util.toMd5(((String)object).getBytes(), true);
            cUIDInfo.imei = string;
        }
        object2 = null;
        object = new File(this.mContext.getFilesDir(), SELF_CUID_FILE);
        if ((this.mSaveMask & 0x10) != 0 || !((File)object).exists()) {
            if (TextUtils.isEmpty((CharSequence)object2)) {
                object2 = DeviceId.encryptCUIDInfo(cUIDInfo.toPersitString());
            }
            this.writeToCuidFile((String)object2);
        }
        if ((bl2 = this.hasWriteSettingsPermission()) && ((this.mSaveMask & 2) != 0 || TextUtils.isEmpty((CharSequence)this.getSystemSettingValue(KEY_DEVICE_ID_V2)))) {
            if (TextUtils.isEmpty((CharSequence)object2)) {
                object2 = DeviceId.encryptCUIDInfo(cUIDInfo.toPersitString());
            }
            this.tryPutSystemSettingValue(KEY_DEVICE_ID_V2, (String)object2);
        }
        if (bl = this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
            file = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid2");
            if ((this.mSaveMask & 8) != 0 || !file.exists()) {
                if (TextUtils.isEmpty((CharSequence)object2)) {
                    object2 = DeviceId.encryptCUIDInfo(cUIDInfo.toPersitString());
                }
                DeviceId.setExternalV2DeviceId((String)object2);
            }
        }
        if (bl2 && ((this.mSaveMask & 1) != 0 || TextUtils.isEmpty((CharSequence)this.getSystemSettingValue(KEY_DEVICE_ID)))) {
            this.tryPutSystemSettingValue(KEY_DEVICE_ID, cUIDInfo.deviceId);
            this.tryPutSystemSettingValue(KEY_IMEI, cUIDInfo.imei);
        }
        if (bl2 && !TextUtils.isEmpty((CharSequence)cUIDInfo.imei)) {
            file = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid");
            if ((this.mSaveMask & 2) != 0 || !file.exists()) {
                DeviceId.setExternalDeviceId(cUIDInfo.imei, cUIDInfo.deviceId);
            }
        }
        return cUIDInfo;
    }

    private boolean hasWriteSettingsPermission() {
        return this.checkSelfPermission("android.permission.WRITE_SETTINGS");
    }

    private boolean hasReadImeiPermission() {
        return this.checkSelfPermission("android.permission.READ_PHONE_STATE");
    }

    private boolean checkSelfPermission(String string) {
        return this.mContext.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    private CUIDInfo getCUidInfoFromSystemSettingV1() {
        Object object;
        String string = this.getSystemSettingValue(KEY_DEVICE_ID);
        String string2 = this.getSystemSettingValue(KEY_IMEI);
        if (TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)(string2 = this.getIMEIFromSystem(DEFAULT_TM_DEVICEID)))) {
            this.tryPutSystemSettingValue(KEY_IMEI, string2);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            object = DeviceId.getAndroidId(this.mContext);
            String string3 = MD5Util.toMd5(("com.baidu" + string2 + (String)object).getBytes(), true);
            string = this.getSystemSettingValue(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            object = new CUIDInfo();
            ((CUIDInfo)object).deviceId = string;
            ((CUIDInfo)object).imei = string2;
            return object;
        }
        return null;
    }

    private CUIDInfo getCuidInfoFromExternalV2() {
        String string;
        File file = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid2");
        if (file.exists() && !TextUtils.isEmpty((CharSequence)(string = DeviceId.getFileContent(file)))) {
            try {
                return CUIDInfo.createFromJson(new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(string.getBytes()))));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private CUIDInfo getExternalV1DeviceId(String string) {
        Object object;
        boolean bl;
        boolean bl2 = bl = Build.VERSION.SDK_INT < 23;
        if (bl && TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        boolean bl3 = false;
        String string2 = DEFAULT_TM_DEVICEID;
        File file = new File(Environment.getExternalStorageDirectory(), "baidu/.cuid");
        if (!file.exists()) {
            file = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid");
            bl3 = true;
        }
        try {
            object = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3);
                stringBuilder.append("\r\n");
            }
            bufferedReader.close();
            String string4 = new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(stringBuilder.toString().getBytes())));
            String[] stringArray = string4.split("=");
            if (stringArray != null && stringArray.length == 2) {
                if (bl && string.equals(stringArray[0])) {
                    string2 = stringArray[1];
                } else if (!bl) {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = stringArray[1];
                    }
                    string2 = stringArray[1];
                }
            }
            if (!bl3) {
                DeviceId.setExternalDeviceId(string, string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            object = new CUIDInfo();
            ((CUIDInfo)object).deviceId = string2;
            ((CUIDInfo)object).imei = string;
            return object;
        }
        return null;
    }

    private static String encryptCUIDInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, string.getBytes()), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DeviceId.handleThrowable(unsupportedEncodingException);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return DEFAULT_TM_DEVICEID;
    }

    private static String decryptCUIDInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(string.getBytes())));
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return DEFAULT_TM_DEVICEID;
        }
    }

    private static void setExternalV2DeviceId(String string) {
        File file = new File(Environment.getExternalStorageDirectory(), EXT_DIR);
        File file2 = new File(file, EXT_FILE_V2);
        try {
            Object object;
            if (file.exists() && !file.isDirectory()) {
                object = new Random();
                File file3 = null;
                File file4 = file.getParentFile();
                String string2 = file.getName();
                while ((file3 = new File(file4, string2 + ((Random)object).nextInt() + ".tmp")).exists()) {
                }
                file.renameTo(file3);
                file3.delete();
            }
            file.mkdirs();
            object = new FileWriter(file2, false);
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setExternalDeviceId(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("=");
        stringBuilder.append(string2);
        File file = new File(Environment.getExternalStorageDirectory(), EXT_DIR);
        File file2 = new File(file, EXT_FILE);
        try {
            Object object;
            Object object2;
            if (file.exists() && !file.isDirectory()) {
                object2 = new Random();
                object = null;
                File file3 = file.getParentFile();
                String string3 = file.getName();
                while (((File)(object = new File(file3, string3 + ((Random)object2).nextInt() + ".tmp"))).exists()) {
                }
                file.renameTo((File)object);
                ((File)object).delete();
            }
            file.mkdirs();
            object2 = new FileWriter(file2, false);
            object = Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, stringBuilder.toString().getBytes()), "utf-8");
            ((Writer)object2).write((String)object);
            ((OutputStreamWriter)object2).flush();
            ((OutputStreamWriter)object2).close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getIMEIFromSystem(String string) {
        String string2 = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            if (telephonyManager != null) {
                string2 = telephonyManager.getDeviceId();
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "Read IMEI failed", exception);
        }
        string2 = DeviceId.imeiCheck(string2);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = string;
        }
        return string2;
    }

    private static String imeiCheck(String string) {
        if (null != string && string.contains(":")) {
            return DEFAULT_TM_DEVICEID;
        }
        return string;
    }

    private static class CUIDInfo {
        public String deviceId;
        public String imei;
        public int version = 2;
        private static final int VERSION = 2;

        private CUIDInfo() {
        }

        public static CUIDInfo createFromJson(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            try {
                JSONObject jSONObject = new JSONObject(string);
                String string2 = jSONObject.getString("deviceid");
                String string3 = jSONObject.getString("imei");
                int n = jSONObject.getInt("ver");
                if (!TextUtils.isEmpty((CharSequence)string2) && string3 != null) {
                    CUIDInfo cUIDInfo = new CUIDInfo();
                    cUIDInfo.deviceId = string2;
                    cUIDInfo.imei = string3;
                    cUIDInfo.version = n;
                    return cUIDInfo;
                }
            }
            catch (JSONException jSONException) {
                DeviceId.handleThrowable(jSONException);
            }
            return null;
        }

        public String toPersitString() {
            try {
                return new JSONObject().put("deviceid", (Object)this.deviceId).put("imei", (Object)this.imei).put("ver", this.version).toString();
            }
            catch (JSONException jSONException) {
                DeviceId.handleThrowable(jSONException);
                return null;
            }
        }

        public String getFinalCUID() {
            String string = this.imei;
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = "0";
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            string = stringBuffer.reverse().toString();
            String string2 = this.deviceId + "|" + string;
            return string2;
        }
    }

    private static class CUIDBuddyInfo {
        public ApplicationInfo appInfo;
        public int priority = 0;
        public boolean sigMatched = false;
        public boolean isSelf = false;

        private CUIDBuddyInfo() {
        }
    }
}

