/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.bba.common.util;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.android.bba.common.security.AESUtil;
import com.baidu.android.bba.common.security.Base64;
import com.baidu.android.bba.common.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;

public final class DeviceId {
    private static final String TAG = "DeviceId";
    private static final boolean DEBUG = false;
    private static final String KEY_IMEI = "bd_setting_i";
    private static final String KEY_DEVICE_ID = "com.baidu.deviceid";
    private static final String AES_KEY = "30212102dicudiab";
    private static final String EXT_FILE = "baidu/.cuid";

    private DeviceId() {
    }

    public static String getDeviceID(Context context) {
        DeviceId.checkPermission(context, "android.permission.WRITE_SETTINGS");
        DeviceId.checkPermission(context, "android.permission.READ_PHONE_STATE");
        DeviceId.checkPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
        boolean bl = false;
        String string = "";
        try {
            string = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)KEY_IMEI);
            if (string == null) {
                string = DeviceId.getIMEI(context);
            }
            Settings.System.putString((ContentResolver)context.getContentResolver(), (String)KEY_IMEI, (String)string);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Settings.System.getString or putString failed", (Throwable)exception);
            bl = true;
        }
        String string2 = DeviceId.getAndroidId(context);
        String string3 = "";
        if (bl) {
            return Util.toMd5(("com.baidu" + string2).getBytes(), true);
        }
        String string4 = null;
        string3 = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)KEY_DEVICE_ID);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string4 = Util.toMd5(("com.baidu" + string + string2).getBytes(), true);
            string3 = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)string4);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                Settings.System.putString((ContentResolver)context.getContentResolver(), (String)KEY_DEVICE_ID, (String)string3);
                DeviceId.setExternalDeviceId(string, string3);
            }
        }
        if (TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)(string3 = DeviceId.getExternalDeviceId(string)))) {
            Settings.System.putString((ContentResolver)context.getContentResolver(), (String)string4, (String)string3);
            Settings.System.putString((ContentResolver)context.getContentResolver(), (String)KEY_DEVICE_ID, (String)string3);
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            String string5 = UUID.randomUUID().toString();
            string3 = Util.toMd5((string + string2 + string5).getBytes(), true);
            Settings.System.putString((ContentResolver)context.getContentResolver(), (String)string4, (String)string3);
            Settings.System.putString((ContentResolver)context.getContentResolver(), (String)KEY_DEVICE_ID, (String)string3);
            DeviceId.setExternalDeviceId(string, string3);
        }
        return string3;
    }

    public static String getIMEI(Context context) {
        String string = "";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null && TextUtils.isEmpty((CharSequence)(string = telephonyManager.getDeviceId()))) {
            string = "";
        }
        return string;
    }

    public static String getAndroidId(Context context) {
        String string = "";
        string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "";
        }
        return string;
    }

    private static void checkPermission(Context context, String string) {
        boolean bl;
        int n = context.checkCallingOrSelfPermission(string);
        boolean bl2 = bl = n == 0;
        if (!bl) {
            throw new SecurityException("Permission Denial: requires permission " + string);
        }
    }

    private static String getExternalDeviceId(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        String string2 = "";
        File file = new File(Environment.getExternalStorageDirectory(), EXT_FILE);
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3);
                stringBuilder.append("\r\n");
            }
            bufferedReader.close();
            String string4 = new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(stringBuilder.toString().getBytes())));
            String[] stringArray = string4.split("=");
            if (stringArray != null && stringArray.length == 2 && string.equals(stringArray[0])) {
                string2 = stringArray[1];
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static void setExternalDeviceId(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("=");
        stringBuilder.append(string2);
        File file = new File(Environment.getExternalStorageDirectory(), EXT_FILE);
        try {
            new File(file.getParent()).mkdirs();
            FileWriter fileWriter = new FileWriter(file, false);
            String string3 = Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, stringBuilder.toString().getBytes()), "utf-8");
            fileWriter.write(string3);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

