/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.appsearch.patchupdate.patch;

import com.baidu.appsearch.patchupdate.patch.SeekableSource;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSeekableSource
implements SeekableSource {
    private ByteBuffer mByteBuffer;

    public ByteBufferSeekableSource(byte[] byArray) {
        this(ByteBuffer.wrap(byArray));
    }

    public ByteBufferSeekableSource(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException("input parameter bb is null");
        }
        this.mByteBuffer = byteBuffer;
        byteBuffer.rewind();
        try {
            this.seek(0L);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void seek(long l) throws IOException {
        if (l > (long)this.mByteBuffer.limit()) {
            throw new IOException("pos " + l + " cannot seek " + this.mByteBuffer.limit());
        }
        this.mByteBuffer.position((int)l);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.mByteBuffer.hasRemaining()) {
            return -1;
        }
        int n = 0;
        while (this.mByteBuffer.hasRemaining() && byteBuffer.hasRemaining()) {
            byteBuffer.put(this.mByteBuffer.get());
            ++n;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.mByteBuffer = null;
    }

    public String toString() {
        return "BBSeekable bb=" + this.mByteBuffer.position() + "-" + this.mByteBuffer.limit() + "";
    }
}

