/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.common.security;

import com.baidu.android.common.security.Base64;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public final class RSAUtil {
    public static final String ALGORITHM_RSA = "RSA";
    public static final String PUBLIC_KEY = "PublicKey";
    public static final String PRIVATE_KEY = "PrivateKey";
    public static final int BYTE_IN_BITS = 8;
    public static final int PT_MAXLEN_OFFSET = 11;

    private RSAUtil() {
    }

    public static Map<String, Object> generateKey(int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM_RSA);
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(PUBLIC_KEY, rSAPublicKey);
        hashMap.put(PRIVATE_KEY, rSAPrivateKey);
        return hashMap;
    }

    public static String getPublicKey(Map<String, Object> map) throws UnsupportedEncodingException {
        Key key = (Key)map.get(PUBLIC_KEY);
        return Base64.encode(key.getEncoded(), "utf-8");
    }

    public static String getPrivateKey(Map<String, Object> map) throws Exception {
        Key key = (Key)map.get(PRIVATE_KEY);
        return Base64.encode(key.getEncoded(), "utf-8");
    }

    public static byte[] decryptByPrivateKey(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = Base64.decode(string.getBytes());
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        return cipher.doFinal(byArray);
    }

    public static byte[] decryptLongByPrivateKey(byte[] byArray, String string, int n) throws Exception {
        int n2;
        byte[] byArray2 = Base64.decode(string.getBytes());
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        int n3 = n / 8;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = byArray.length;
        for (int i = 0; i < n4; i += n2) {
            int n5 = n4 - i;
            n2 = n3 < n5 ? n3 : n5;
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, i, byArray3, 0, n2);
            stringBuilder.append(new String(cipher.doFinal(byArray3)));
        }
        return stringBuilder.toString().getBytes();
    }

    public static byte[] decryptByPublicKey(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = Base64.decode(string.getBytes());
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, publicKey);
        return cipher.doFinal(byArray);
    }

    public static byte[] encryptByPublicKey(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = Base64.decode(string.getBytes());
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        return cipher.doFinal(byArray);
    }

    public static byte[] encryptLongByPublicKey(byte[] byArray, String string, int n) throws Exception {
        byte[] byArray2 = Base64.decode(string.getBytes());
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        int n2 = n / 8;
        int n3 = n2 - 11;
        int n4 = byArray.length;
        byte[] byArray3 = new byte[(n4 + n3 - 1) / n3 * n2];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = n4 - n5;
            int n8 = n3 < n7 ? n3 : n7;
            byte[] byArray4 = new byte[n8];
            System.arraycopy(byArray, n5, byArray4, 0, n8);
            n5 += n8;
            System.arraycopy(cipher.doFinal(byArray4), 0, byArray3, n6, n2);
            n6 += n2;
        }
        return byArray3;
    }

    public static byte[] encryptByPrivateKey(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = Base64.decode(string.getBytes());
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, privateKey);
        return cipher.doFinal(byArray);
    }

    public static RSAPublicKey generateRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception(noSuchAlgorithmException.getMessage());
        }
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            return (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Exception(invalidKeySpecException.getMessage());
        }
    }

    public static RSAPrivateKey generateRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception(noSuchAlgorithmException.getMessage());
        }
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        try {
            return (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Exception(invalidKeySpecException.getMessage());
        }
    }
}

