/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.common.security;

public class RC4 {
    private static final int STATE_LENGTH = 256;
    private byte[] engineState = null;
    private int x = 0;
    private int y = 0;
    private byte[] workingKey = null;

    public RC4(String string) {
        this.workingKey = string.getBytes();
    }

    private void processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n + n2 > byArray.length) {
            throw new RuntimeException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new RuntimeException("output buffer too short");
        }
        for (int i = 0; i < n2; ++i) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.engineState[this.x] + this.y & 0xFF;
            byte by = this.engineState[this.x];
            this.engineState[this.x] = this.engineState[this.y];
            this.engineState[this.y] = by;
            byArray2[i + n3] = (byte)(byArray[i + n] ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
        }
    }

    private void setKey(byte[] byArray) {
        int n;
        this.x = 0;
        this.y = 0;
        if (this.engineState == null) {
            this.engineState = new byte[256];
        }
        for (n = 0; n < 256; ++n) {
            this.engineState[n] = (byte)n;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < 256; ++i) {
            n2 = (byArray[n] & 0xFF) + this.engineState[i] + n2 & 0xFF;
            byte by = this.engineState[i];
            this.engineState[i] = this.engineState[n2];
            this.engineState[n2] = by;
            n = (n + 1) % byArray.length;
        }
    }

    private void reset() {
        this.setKey(this.workingKey);
    }

    public byte[] encrypt(byte[] byArray) {
        this.reset();
        byte[] byArray2 = new byte[byArray.length];
        this.processBytes(byArray, 0, byArray.length, byArray2, 0);
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray) {
        this.reset();
        byte[] byArray2 = new byte[byArray.length];
        this.processBytes(byArray, 0, byArray.length, byArray2, 0);
        return byArray2;
    }
}

