/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Map;

public final class ITFReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 204;
    private static final int W = 3;
    private static final int N = 1;
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{44, 24, 20, 18, 16, 14, 12, 10, 8, 6};
    private int narrowLineWidth = -1;
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN_REVERSED = new int[]{1, 1, 3};
    static final int[][] PATTERNS = new int[][]{{1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws FormatException, NotFoundException {
        int[] startRange = this.decodeStart(row);
        int[] endRange = this.decodeEnd(row);
        StringBuilder result = new StringBuilder(20);
        ITFReader.decodeMiddle(row, startRange[1], endRange[0], result);
        String resultString = result.toString();
        int[] allowedLengths = null;
        if (hints != null) {
            allowedLengths = (int[])hints.get((Object)DecodeHintType.ALLOWED_LENGTHS);
        }
        if (allowedLengths == null) {
            allowedLengths = DEFAULT_ALLOWED_LENGTHS;
        }
        int length = resultString.length();
        boolean lengthOK = false;
        int[] nArray = allowedLengths;
        int n = allowedLengths.length;
        int n2 = 0;
        while (n2 < n) {
            int allowedLength = nArray[n2];
            if (length == allowedLength) {
                lengthOK = true;
                break;
            }
            ++n2;
        }
        if (!lengthOK) {
            throw FormatException.getFormatInstance();
        }
        return new Result(resultString, null, new ResultPoint[]{new ResultPoint(startRange[1], rowNumber), new ResultPoint(endRange[0], rowNumber)}, BarcodeFormat.ITF);
    }

    private static void decodeMiddle(BitArray row, int payloadStart, int payloadEnd, StringBuilder resultString) throws NotFoundException {
        int[] counterDigitPair = new int[10];
        int[] counterBlack = new int[5];
        int[] counterWhite = new int[5];
        while (payloadStart < payloadEnd) {
            ITFReader.recordPattern(row, payloadStart, counterDigitPair);
            int k = 0;
            while (k < 5) {
                int twoK = k << 1;
                counterBlack[k] = counterDigitPair[twoK];
                counterWhite[k] = counterDigitPair[twoK + 1];
                ++k;
            }
            int bestMatch = ITFReader.decodeDigit(counterBlack);
            resultString.append((char)(48 + bestMatch));
            bestMatch = ITFReader.decodeDigit(counterWhite);
            resultString.append((char)(48 + bestMatch));
            int[] nArray = counterDigitPair;
            int n = counterDigitPair.length;
            int n2 = 0;
            while (n2 < n) {
                int counterDigit = nArray[n2];
                payloadStart += counterDigit;
                ++n2;
            }
        }
    }

    int[] decodeStart(BitArray row) throws NotFoundException {
        int endStart = ITFReader.skipWhiteSpace(row);
        int[] startPattern = ITFReader.findGuardPattern(row, endStart, START_PATTERN);
        this.narrowLineWidth = startPattern[1] - startPattern[0] >> 2;
        this.validateQuietZone(row, startPattern[0]);
        return startPattern;
    }

    private void validateQuietZone(BitArray row, int startPattern) throws NotFoundException {
        int quietCount = this.narrowLineWidth * 10;
        int i = startPattern - 1;
        while (quietCount > 0 && i >= 0) {
            if (row.get(i)) break;
            --quietCount;
            --i;
        }
        if (quietCount != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static int skipWhiteSpace(BitArray row) throws NotFoundException {
        int width = row.getSize();
        int endStart = row.getNextSet(0);
        if (endStart == width) {
            throw NotFoundException.getNotFoundInstance();
        }
        return endStart;
    }

    int[] decodeEnd(BitArray row) throws NotFoundException {
        row.reverse();
        try {
            int endStart = ITFReader.skipWhiteSpace(row);
            int[] endPattern = ITFReader.findGuardPattern(row, endStart, END_PATTERN_REVERSED);
            this.validateQuietZone(row, endPattern[0]);
            int temp = endPattern[0];
            endPattern[0] = row.getSize() - endPattern[1];
            endPattern[1] = row.getSize() - temp;
            int[] nArray = endPattern;
            return nArray;
        }
        finally {
            row.reverse();
        }
    }

    private static int[] findGuardPattern(BitArray row, int rowOffset, int[] pattern) throws NotFoundException {
        int patternLength = pattern.length;
        int[] counters = new int[patternLength];
        int width = row.getSize();
        boolean isWhite = false;
        int counterPosition = 0;
        int patternStart = rowOffset;
        int x = rowOffset;
        while (x < width) {
            if (row.get(x) ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == patternLength - 1) {
                    if (ITFReader.patternMatchVariance(counters, pattern, 204) < 107) {
                        return new int[]{patternStart, x};
                    }
                    patternStart += counters[0] + counters[1];
                    System.arraycopy(counters, 2, counters, 0, patternLength - 2);
                    counters[patternLength - 2] = 0;
                    counters[patternLength - 1] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++x;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeDigit(int[] counters) throws NotFoundException {
        int bestVariance = 107;
        int bestMatch = -1;
        int max = PATTERNS.length;
        int i = 0;
        while (i < max) {
            int[] pattern = PATTERNS[i];
            int variance = ITFReader.patternMatchVariance(counters, pattern, 204);
            if (variance < bestVariance) {
                bestVariance = variance;
                bestMatch = i;
            }
            ++i;
        }
        if (bestMatch >= 0) {
            return bestMatch;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

